/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.mapping;

import com.shadowvc.sdk.ApiException;
import com.shadowvc.sdk.EopResponse;
import com.shadowvc.sdk.internal.mapping.ApiField;
import com.shadowvc.sdk.internal.mapping.ApiListField;
import com.shadowvc.sdk.internal.mapping.Reader;
import com.shadowvc.sdk.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Set<String> baseFields = new HashSet<String>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws ApiException {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                Object value;
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                String itemName = pd.getName();
                String listName = null;
                Field field = baseFields.contains(itemName) && EopResponse.class.isAssignableFrom(clazz) ? EopResponse.class.getDeclaredField(itemName) : clazz.getDeclaredField(itemName);
                ApiField jsonField = field.getAnnotation(ApiField.class);
                ApiListField jsonListField = field.getAnnotation(ApiListField.class);
                if (jsonField != null && StringUtils.isEmpty(itemName = jsonField.value())) {
                    itemName = pd.getName();
                }
                if (jsonListField != null && StringUtils.isEmpty(listName = jsonListField.value())) {
                    listName = pd.getName();
                }
                if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                Class<?> typeClass = field.getType();
                if (String.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof String) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a String");
                    }
                    if (value != null) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    method.invoke(rsp, "");
                    continue;
                }
                if (Long.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Long) {
                        method.invoke(rsp, (Long)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Number(Long)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Long.valueOf(value.toString()));
                    continue;
                }
                if (Integer.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Integer) {
                        method.invoke(rsp, (Integer)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Number(Integer)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Integer.valueOf(value.toString()));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Boolean) {
                        method.invoke(rsp, (Boolean)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Boolean");
                    }
                    if (value == null) continue;
                    method.invoke(rsp, Boolean.valueOf(value.toString()));
                    continue;
                }
                if (Double.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Double) {
                        method.invoke(rsp, (Double)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new ApiException(itemName + " is not a Double");
                }
                if (Number.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Number) {
                        method.invoke(rsp, (Number)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new ApiException(itemName + " is not a Number");
                }
                if (Date.class.isAssignableFrom(typeClass)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    Object value2 = reader.getPrimitiveObject(itemName);
                    if (!(value2 instanceof String)) continue;
                    method.invoke(rsp, format.parse(value2.toString()));
                    continue;
                }
                if (List.class.isAssignableFrom(typeClass)) {
                    Class subType;
                    List<?> listObjs;
                    ParameterizedType paramType;
                    Type[] genericTypes;
                    Type fieldType = field.getGenericType();
                    if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                    method.invoke(rsp, listObjs);
                    continue;
                }
                Object obj = reader.getObject(itemName, typeClass);
                if (obj == null) continue;
                method.invoke(rsp, obj);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return rsp;
    }

    static {
        baseFields.add("errorCode");
        baseFields.add("msg");
        baseFields.add("subCode");
        baseFields.add("subMsg");
        baseFields.add("responseBody");
        baseFields.add("requestParams");
        baseFields.add("success");
        baseFields.add("requestUrl");
    }
}

