/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.parser;

import com.shadowvc.sdk.ApiException;
import com.shadowvc.sdk.EopResponse;
import com.shadowvc.sdk.internal.mapping.Converter;
import com.shadowvc.sdk.internal.mapping.Converters;
import com.shadowvc.sdk.internal.mapping.Reader;
import com.shadowvc.sdk.internal.util.json.ExceptionErrorListener;
import com.shadowvc.sdk.internal.util.json.JSONReader;
import com.shadowvc.sdk.internal.util.json.JSONValidatingReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonConverter
implements Converter {
    @Override
    public <T extends EopResponse> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(rsp);
        if (rootObj instanceof Map) {
            Map rootJson = (Map)rootObj;
            Collection values = rootJson.values();
            for (Object rspObj : values) {
                if (!(rspObj instanceof Map)) continue;
                Map rspJson = (Map)rspObj;
                return (T)((EopResponse)this.fromJson(rspJson, clazz));
            }
        }
        return null;
    }

    private <T> T fromJson(final Map<?, ?> json, Class<T> clazz) throws ApiException {
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Map map = (Map)tmp;
                    return JsonConverter.this.fromJson(map, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws ApiException {
                ArrayList<Object> listObjs = null;
                Object listTmp = json.get(listName);
                if (listTmp instanceof List) {
                    listObjs = new ArrayList<Object>();
                    List tmpList = (List)listTmp;
                    for (Object subTmp : tmpList) {
                        if (subTmp instanceof Map) {
                            Map subMap = (Map)subTmp;
                            Object subObj = JsonConverter.this.fromJson(subMap, subType);
                            if (subObj == null) continue;
                            listObjs.add(subObj);
                            continue;
                        }
                        if (subTmp instanceof List) continue;
                        listObjs.add(subTmp);
                    }
                }
                return listObjs;
            }
        });
    }
}

