/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.stream;

import com.shadowvc.sdk.internal.stream.EopCometStreamRequest;
import com.shadowvc.sdk.internal.stream.connect.HttpConnectionConfiguration;
import com.shadowvc.sdk.internal.stream.message.MessageHandlerConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;

public class Configuration
implements HttpConnectionConfiguration,
MessageHandlerConfiguration {
    private String connectUrl = "http://stream.api.ecbox.com/rest";
    private String signMethod = "md5";
    private int httpConnectionTimeout = 5;
    private int httpReadTimeout = 90;
    private int httpConnectRetryCount = 225;
    private int httpConnectRetryInterval = 16;
    private int sleepTimeOfServerInUpgrade = 300;
    private Map<String, String> reqHeader;
    private int httpReconnectInterval = 86100;
    private int minThreads = 5;
    private int maxThreads = 100;
    private int queueSize = 50000;
    private RejectedExecutionHandler msgConsumeThreadPoolRejectHandler;
    private Set<EopCometStreamRequest> connectReqParam;

    public Configuration(String appKey, String secret, Long instanceUserId, String accessToken, String connectionName) {
        EopCometStreamRequest cometReq = new EopCometStreamRequest(appKey, secret, instanceUserId, accessToken, connectionName);
        this.connectReqParam = new HashSet<EopCometStreamRequest>(1);
        this.connectReqParam.add(cometReq);
    }

    public Configuration(Set<EopCometStreamRequest> cometRequest) {
        if (cometRequest == null || cometRequest != null && cometRequest.size() == 0) {
            throw new RuntimeException("comet request param is null");
        }
        this.connectReqParam = cometRequest;
    }

    public void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    @Override
    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    @Override
    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    public void setHttpConnectRetryCount(int httpConnectRetryCount) {
        this.httpConnectRetryCount = httpConnectRetryCount;
    }

    @Override
    public int getHttpConnectRetryCount() {
        return this.httpConnectRetryCount;
    }

    public void setConnectUrl(String connectUrl) {
        this.connectUrl = connectUrl;
    }

    @Override
    public String getConnectUrl() {
        return this.connectUrl;
    }

    public void setHttpConnectRetryInterval(int httpConnectRetryInterval) {
        this.httpConnectRetryInterval = httpConnectRetryInterval;
    }

    @Override
    public int getHttpConnectRetryInterval() {
        return this.httpConnectRetryInterval;
    }

    public void setSleepTimeOfServerInUpgrade(int sleepSecond) {
        this.sleepTimeOfServerInUpgrade = sleepSecond;
    }

    @Override
    public int getSleepTimeOfServerInUpgrade() {
        return this.sleepTimeOfServerInUpgrade;
    }

    public void setHttpReconnectInterval(int httpReconnectInterval) {
        this.httpReconnectInterval = httpReconnectInterval;
    }

    @Override
    public int getHttpReconnectInterval() {
        return this.httpReconnectInterval;
    }

    public void setRequestHeader(Map<String, String> reqHeader) {
        this.reqHeader = reqHeader;
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return this.reqHeader;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    @Override
    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    public RejectedExecutionHandler getMsgConsumeThreadPoolRejectHandler() {
        return this.msgConsumeThreadPoolRejectHandler;
    }

    public void setMsgConsumeThreadPoolRejectHandler(RejectedExecutionHandler msgConsumeThreadPoolRejectHandler) {
        this.msgConsumeThreadPoolRejectHandler = msgConsumeThreadPoolRejectHandler;
    }

    public void setSignMethd(String signMethod) {
        this.signMethod = signMethod;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public Set<EopCometStreamRequest> getConnectReqParam() {
        return this.connectReqParam;
    }
}

