/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.stream;

import com.shadowvc.sdk.EopHashMap;
import com.shadowvc.sdk.EopUtils;
import com.shadowvc.sdk.internal.stream.Configuration;
import com.shadowvc.sdk.internal.stream.EopCometStream;
import com.shadowvc.sdk.internal.stream.EopCometStreamRequest;
import com.shadowvc.sdk.internal.stream.EopCometSysErrorException;
import com.shadowvc.sdk.internal.stream.connect.ConnectionLifeCycleListener;
import com.shadowvc.sdk.internal.stream.connect.HttpClient;
import com.shadowvc.sdk.internal.stream.connect.HttpResponse;
import com.shadowvc.sdk.internal.stream.message.EopCometMessageListener;
import com.shadowvc.sdk.internal.stream.message.StreamMessageConsume;
import com.shadowvc.sdk.internal.stream.message.StreamMsgConsumeFactory;
import com.shadowvc.sdk.internal.util.RequestParamHolder;
import com.shadowvc.sdk.internal.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EopCometStreamImpl
implements EopCometStream {
    private static final Log logger = LogFactory.getLog(EopCometStreamImpl.class);
    private ConnectionLifeCycleListener connectionListener;
    private EopCometMessageListener cometMessageListener;
    private Configuration conf;
    private StreamMsgConsumeFactory msgConsumeFactory = null;
    private boolean gloableStop = false;
    private List<ControlThread> controlThreads = new ArrayList<ControlThread>();

    protected EopCometStreamImpl(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void setConnectionListener(ConnectionLifeCycleListener connectionLifeCycleListener) {
        this.connectionListener = connectionLifeCycleListener;
    }

    @Override
    public void setMessageListener(EopCometMessageListener cometMessageListener) {
        this.cometMessageListener = cometMessageListener;
    }

    @Override
    public void start() {
        Set<EopCometStreamRequest> cometRequests = this.conf.getConnectReqParam();
        for (EopCometStreamRequest cometRequest : cometRequests) {
            if (cometRequest.getConnectListener() == null) {
                cometRequest.setConnectListener(this.connectionListener);
            }
            if (cometRequest.getMsgListener() != null) continue;
            if (this.cometMessageListener == null) {
                throw new RuntimeException("Comet message listener must not null");
            }
            cometRequest.setMsgListener(this.cometMessageListener);
        }
        this.msgConsumeFactory = new StreamMsgConsumeFactory(this.conf.getMinThreads(), this.conf.getMaxThreads(), this.conf.getQueueSize(), this.conf.getMsgConsumeThreadPoolRejectHandler());
        for (EopCometStreamRequest cometRequest : cometRequests) {
            ControlThread ct = new ControlThread(cometRequest, this.conf);
            this.controlThreads.add(ct);
            Thread t = new Thread((Runnable)ct, "stream-control-thread-connectid-" + cometRequest.getConnectionName());
            t.setDaemon(false);
            t.start();
        }
    }

    @Override
    public void addNewStreamClient(EopCometStreamRequest newClient) {
        if (newClient.getConnectListener() == null) {
            newClient.setConnectListener(this.connectionListener);
        }
        if (newClient.getMsgListener() == null) {
            newClient.setMsgListener(this.cometMessageListener);
        }
        ControlThread ct = new ControlThread(newClient, this.conf);
        this.controlThreads.add(ct);
        Thread t = new Thread((Runnable)ct, "stream-control-thread-connectid-" + newClient.getConnectionName());
        t.setDaemon(false);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object[] copyControlThreads;
        logger.warn((Object)"start stop stream consume...");
        this.gloableStop = true;
        for (Object o : copyControlThreads = this.controlThreads.toArray()) {
            if (!(o instanceof ControlThread)) continue;
            ControlThread ct = (ControlThread)o;
            try {
                ct.lock.lock();
                ct.controlCondition.signalAll();
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            finally {
                ct.lock.unlock();
            }
        }
        this.msgConsumeFactory.shutdown();
        logger.warn((Object)"stream consume stoped...");
    }

    class TopCometStreamConsume
    implements Runnable {
        private StreamMessageConsume stream;
        private boolean closed = false;
        private ControlThread ct;
        private ConnectionLifeCycleListener connectListener;

        TopCometStreamConsume(StreamMessageConsume stream, ControlThread ct, ConnectionLifeCycleListener connectListener) {
            this.stream = stream;
            this.ct = ct;
            this.connectListener = connectListener;
        }

        @Override
        public void run() {
            while (!EopCometStreamImpl.this.gloableStop && !this.closed && this.stream.isAlive()) {
                try {
                    this.stream.nextMsg();
                }
                catch (IOException e) {
                    if (this.stream != null) {
                        try {
                            this.stream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.stream = null;
                    this.closed = true;
                    this.ct.readTimeoutOccureTimes++;
                    if (System.currentTimeMillis() - this.ct.lastStartConsumeThread < 1800000L) {
                        if (this.ct.readTimeoutOccureTimes >= 10) {
                            if (this.connectListener != null) {
                                try {
                                    this.connectListener.onMaxReadTimeoutException();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.ct.readTimeoutOccureTimes = 0;
                        }
                    } else {
                        this.ct.readTimeoutOccureTimes = 0;
                    }
                    this.ct.serverRespCode = "500";
                    try {
                        this.ct.lock.lock();
                        this.ct.controlCondition.signalAll();
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        this.ct.lock.unlock();
                    }
                }
            }
            this.close();
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class ControlThread
    implements Runnable {
        private static final String threadName = "eop-stream-consume-thread";
        private TopCometStreamConsume currentStreamConsume;
        private boolean isReconnect = false;
        private String serverRespCode = "501";
        private ReentrantLock lock = new ReentrantLock();
        private Condition controlCondition = this.lock.newCondition();
        private int readTimeoutOccureTimes = 0;
        private long lastStartConsumeThread = System.currentTimeMillis();
        private boolean stop = false;
        private EopCometStreamRequest cometReq;
        private Configuration conf;

        public ControlThread(EopCometStreamRequest cometReq, Configuration conf) {
            this.cometReq = cometReq;
            this.conf = conf;
        }

        public ReentrantLock getLock() {
            return this.lock;
        }

        public Condition getControlCondition() {
            return this.controlCondition;
        }

        public void setServerRespCode(String serverRespCode) {
            this.serverRespCode = serverRespCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long lastSleepTime = 0L;
            while (!this.stop && !EopCometStreamImpl.this.gloableStop) {
                try {
                    if ("102".equals(this.serverRespCode)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Server is upgrade sleep " + this.conf.getSleepTimeOfServerInUpgrade() + " seconds"));
                        }
                        try {
                            Thread.sleep(this.conf.getSleepTimeOfServerInUpgrade() * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.startConsumeThread();
                    } else if ("501".equals(this.serverRespCode) || "103".equals(this.serverRespCode) || "101".equals(this.serverRespCode) || "500".equals(this.serverRespCode)) {
                        this.startConsumeThread();
                    } else if ("104".equals(this.serverRespCode) || "105".equals(this.serverRespCode)) {
                        if ("104".equals(this.serverRespCode) && !this.isReconnect || "105".equals(this.serverRespCode)) {
                            this.stop = true;
                            if (this.currentStreamConsume == null) break;
                            this.currentStreamConsume.closed = true;
                            break;
                        }
                    } else {
                        this.stop = true;
                        break;
                    }
                    if (this.stop || EopCometStreamImpl.this.gloableStop) continue;
                    try {
                        this.lock.lock();
                        lastSleepTime = System.currentTimeMillis();
                        this.controlCondition.await(this.conf.getHttpReconnectInterval(), TimeUnit.SECONDS);
                        if (System.currentTimeMillis() - lastSleepTime < (long)((this.conf.getHttpReconnectInterval() - 300) * 1000)) continue;
                        this.serverRespCode = "500";
                        this.isReconnect = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"Occur some error,stop the stream consume", e);
                    this.stop = true;
                    try {
                        this.lock.lock();
                        this.controlCondition.signalAll();
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            if (this.currentStreamConsume != null) {
                this.currentStreamConsume.close();
            }
            EopCometStreamImpl.this.controlThreads.remove(this);
        }

        private void startConsumeThread() {
            StreamMessageConsume stream = null;
            try {
                stream = this.getMsgStreamImpl();
            }
            catch (Exception ex) {
                this.stop = true;
                EopCometStreamImpl.this.gloableStop = true;
                if (this.cometReq.getConnectListener() != null) {
                    this.cometReq.getConnectListener().onException(ex);
                }
                return;
            }
            this.currentStreamConsume = new TopCometStreamConsume(stream, this, this.cometReq.getConnectListener());
            Thread consumeThread = new Thread((Runnable)this.currentStreamConsume, threadName);
            consumeThread.setDaemon(true);
            consumeThread.start();
            this.lastStartConsumeThread = System.currentTimeMillis();
        }

        private StreamMessageConsume getMsgStreamImpl() throws EopCometSysErrorException, Exception {
            if (this.cometReq.getConnectListener() != null) {
                this.cometReq.getConnectListener().onBeforeConnect();
            }
            EopHashMap param = new EopHashMap();
            param.put("app_key", this.cometReq.getAppKey());
            param.put("instance_user_id", (Object)this.cometReq.getInstanceUserId());
            param.put("timestamp", (Object)(System.currentTimeMillis() / 1000L));
            EopHashMap otherParam = new EopHashMap();
            if (!StringUtils.isEmpty(this.conf.getSignMethod())) {
                otherParam.put("sign_method", this.conf.getSignMethod());
            }
            if (!StringUtils.isEmpty(this.cometReq.getAccessToken())) {
                otherParam.put("access_token", this.cometReq.getAccessToken());
            }
            if (!StringUtils.isEmpty(this.cometReq.getConnectionName())) {
                otherParam.put("connection_name", this.cometReq.getConnectionName());
            }
            if (otherParam != null) {
                for (Map.Entry e : otherParam.entrySet()) {
                    param.put((String)e.getKey(), (String)e.getValue());
                }
            }
            RequestParamHolder paramHolder = new RequestParamHolder();
            paramHolder.setProMustParams(param);
            String sign = null;
            try {
                sign = EopUtils.signEopRequestNew(paramHolder, this.cometReq.getSecret(), false);
                if (StringUtils.isEmpty(sign)) {
                    throw new RuntimeException("Get sign error");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            param.put("sign", sign);
            HttpClient httpClient = new HttpClient(this.conf, param);
            HttpResponse response = httpClient.post();
            return new StreamMessageConsume(EopCometStreamImpl.this.msgConsumeFactory, response, this.cometReq.getMsgListener(), this);
        }
    }
}

