/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.stream;

import com.shadowvc.sdk.EopUtils;
import com.shadowvc.sdk.internal.stream.connect.ConnectionLifeCycleListener;
import com.shadowvc.sdk.internal.stream.message.EopCometMessageListener;
import com.shadowvc.sdk.internal.util.StringUtils;

public class EopCometStreamRequest {
    private String appKey;
    private String secret;
    private Long instanceUserId;
    private String accessToken;
    private String connectionName;
    private ConnectionLifeCycleListener connectListener;
    private EopCometMessageListener msgListener;

    public EopCometStreamRequest(String appKey, String secret, long instanceUserId, String accessToken, String connectionName) {
        if (StringUtils.isEmpty(appKey)) {
            throw new RuntimeException("appkey is null");
        }
        if (StringUtils.isEmpty(secret)) {
            throw new RuntimeException("secret is null");
        }
        if (instanceUserId < 1L) {
            throw new RuntimeException("instanceUserId is not validate");
        }
        this.connectionName = StringUtils.isEmpty(connectionName) ? EopUtils.getLocalNetWorkIp() : connectionName;
        this.appKey = appKey;
        this.secret = secret;
        this.instanceUserId = instanceUserId;
        this.accessToken = accessToken;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getSecret() {
        return this.secret;
    }

    public long getInstanceUserId() {
        return this.instanceUserId;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public ConnectionLifeCycleListener getConnectListener() {
        return this.connectListener;
    }

    public void setConnectListener(ConnectionLifeCycleListener connectListener) {
        this.connectListener = connectListener;
    }

    public EopCometMessageListener getMsgListener() {
        return this.msgListener;
    }

    public void setMsgListener(EopCometMessageListener msgListener) {
        this.msgListener = msgListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appKey == null ? 0 : this.appKey.hashCode());
        result = 31 * result + (this.connectionName == null ? 0 : this.connectionName.hashCode());
        result = 31 * result + (this.instanceUserId == null ? 0 : this.instanceUserId.hashCode());
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EopCometStreamRequest other = (EopCometStreamRequest)obj;
        if (this.appKey == null ? other.appKey != null : !this.appKey.equals(other.appKey)) {
            return false;
        }
        if (this.connectionName == null ? other.connectionName != null : !this.connectionName.equals(other.connectionName)) {
            return false;
        }
        if (this.instanceUserId == null ? other.instanceUserId != null : !this.instanceUserId.equals(other.instanceUserId)) {
            return false;
        }
        return !(this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken));
    }
}

