/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.stream.message;

import com.shadowvc.sdk.internal.stream.EopCometStreamImpl;
import com.shadowvc.sdk.internal.stream.connect.HttpResponse;
import com.shadowvc.sdk.internal.stream.message.EopCometMessageListener;
import com.shadowvc.sdk.internal.stream.message.StreamMsgConsumeFactory;
import com.shadowvc.sdk.internal.util.StringUtils;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamMessageConsume {
    private static final Log log = LogFactory.getLog(StreamMessageConsume.class);
    private static final Pattern pattern = Pattern.compile("\\{\"packet\":\\{\"code\":(\\d+)(,\"msg\":(.+))?\\}\\}");
    private HttpResponse response;
    private StreamMsgConsumeFactory msgConsumeFactory;
    private boolean streamAlive = true;
    private EopCometMessageListener msgListener;
    private Condition controlCondition;
    private Lock lock;
    private EopCometStreamImpl.ControlThread ct;
    private boolean isServerKickOffSend = false;

    public StreamMessageConsume(StreamMsgConsumeFactory msgConsumeFactory, HttpResponse response, EopCometMessageListener msgListener, EopCometStreamImpl.ControlThread ct) {
        this.msgConsumeFactory = msgConsumeFactory;
        this.response = response;
        this.msgListener = msgListener;
        this.controlCondition = ct.getControlCondition();
        this.lock = ct.getLock();
        this.ct = ct;
    }

    public void nextMsg() throws IOException {
        if (!this.streamAlive) {
            throw new IOException("Stream closed");
        }
        try {
            String line = this.response.getMsg();
            if (line == null) {
                this.streamAlive = false;
                this.response.close();
                return;
            }
            this.msgConsumeFactory.consume(new StreamEvent(line));
        }
        catch (IOException e) {
            this.response.close();
            this.streamAlive = false;
            throw e;
        }
        catch (RejectedExecutionException rejectException) {
            log.error((Object)"Message consume thread pool is full:", (Throwable)rejectException);
        }
        catch (NullPointerException npe) {
            log.error((Object)"Null point exception:", (Throwable)npe);
        }
    }

    public boolean isAlive() {
        return this.streamAlive;
    }

    private void parseLine(String msg) {
        if (!StringUtils.isEmpty(msg)) {
            try {
                Matcher matcher = pattern.matcher(msg);
                if (matcher.find()) {
                    String code = matcher.group(1);
                    if ("202".equals(code)) {
                        this.msgListener.onReceiveMsg(matcher.group(3));
                    } else if ("201".equals(code)) {
                        this.msgListener.onHeartBeat();
                    } else if ("101".equals(code)) {
                        this.weakUp(code);
                    } else if ("203".equals(code)) {
                        this.msgListener.onDiscardMsg(matcher.group(3));
                    } else if ("102".equals(code)) {
                        this.msgListener.onServerUpgrade(matcher.group(3));
                        this.weakUp(code);
                    } else if ("103".equals(code)) {
                        this.msgListener.onServerRehash();
                        this.weakUp(code);
                    } else if ("104".equals(code)) {
                        this.msgListener.onClientKickOff();
                        this.weakUp(code);
                    } else if ("105".equals(code)) {
                        this.weakUp(code);
                    } else if ("200".equals(code)) {
                        this.msgListener.onConnectMsg(matcher.group(3));
                    } else {
                        this.msgListener.onOtherMsg(matcher.group(3));
                    }
                }
            }
            catch (Exception e) {
                this.msgListener.onException(e);
            }
        }
    }

    private void weakUp(String code) {
        try {
            this.lock.lock();
            if (!"105".equals(code)) {
                this.ct.setServerRespCode(code);
                this.controlCondition.signalAll();
            } else if (!this.isServerKickOffSend) {
                this.isServerKickOffSend = true;
                this.ct.setServerRespCode(code);
                this.msgListener.onServerKickOff();
                this.controlCondition.signalAll();
            } else {
                this.controlCondition.signalAll();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.streamAlive = false;
        this.response.close();
    }

    private class StreamEvent
    implements Runnable {
        private String msg;

        public StreamEvent(String msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            StreamMessageConsume.this.parseLine(this.msg);
        }
    }
}

