/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.stream.message;

import com.shadowvc.sdk.internal.stream.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class StreamMsgConsumeFactory {
    private int minThreads;
    private int maxThreads;
    private int queueSize;
    private ThreadPoolExecutor threadPool;
    private boolean isShutDown = false;

    public StreamMsgConsumeFactory(int minThreads, int maxThreads, int queueSize, RejectedExecutionHandler rejectHandler) {
        if (minThreads <= 0 || maxThreads <= 0 || queueSize <= 0) {
            throw new RuntimeException("minThread,maxThread and queueSize must large than 0");
        }
        this.minThreads = minThreads;
        this.maxThreads = maxThreads;
        this.queueSize = queueSize;
        this.threadPool = new ThreadPoolExecutor(this.minThreads, this.maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize), new NamedThreadFactory("pool-msg-consume", true), rejectHandler == null ? new ThreadPoolExecutor.AbortPolicy() : rejectHandler);
    }

    public void consume(Runnable task) throws RejectedExecutionException, NullPointerException {
        if (!this.isShutDown) {
            this.threadPool.execute(task);
        }
    }

    public void shutdown() {
        this.isShutDown = true;
        try {
            this.threadPool.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

