/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.util;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class Map2JsonConvert {
    private static final String QUOTE = "\"";

    public static String buildJsonBody(Map<String, Object> body, boolean addComma) {
        StringBuilder sbJsonBody = new StringBuilder();
        sbJsonBody.append("{");
        Set<String> keySet = body.keySet();
        int count = 0;
        int size = keySet.size();
        for (String key : keySet) {
            sbJsonBody.append(Map2JsonConvert.buildJsonField(key, body.get(key), ++count != size));
        }
        sbJsonBody.append("}");
        return sbJsonBody.toString();
    }

    private static String buildJsonField(String key, Object value, boolean addComma) {
        StringBuilder sbJsonField = new StringBuilder();
        sbJsonField.append(QUOTE).append(key).append(QUOTE).append(": ");
        sbJsonField.append(Map2JsonConvert.buildJsonValue(value, addComma));
        return sbJsonField.toString();
    }

    public static String buildJsonValue(Object value, boolean addComma) {
        StringBuilder sbJsonValue = new StringBuilder();
        if (value == null) {
            sbJsonValue.append(value);
        } else if (value instanceof String) {
            sbJsonValue.append(QUOTE).append(value).append(QUOTE);
        } else if (value instanceof Integer || value instanceof Long || value instanceof Double) {
            sbJsonValue.append(value);
        } else if (value instanceof Date) {
            String date = Map2JsonConvert.formatDate((Date)value);
            sbJsonValue.append(QUOTE).append(date).append(QUOTE);
        } else if (value.getClass().isArray() || value instanceof Collection) {
            sbJsonValue.append(Map2JsonConvert.buildJsonArray(value, addComma));
        } else if (value instanceof Map) {
            sbJsonValue.append(Map2JsonConvert.buildJsonBody((Map)value, addComma));
        }
        sbJsonValue.append(Map2JsonConvert.buildJsonTail(addComma));
        return sbJsonValue.toString();
    }

    public static String buildJsonArray(Object value, boolean addComma) {
        StringBuilder sbJsonArray = new StringBuilder();
        sbJsonArray.append("[");
        Object[] objArray = null;
        if (value.getClass().isArray()) {
            objArray = (Object[])value;
        } else if (value instanceof Collection) {
            objArray = ((Collection)value).toArray();
        }
        int size = objArray.length;
        int count = 0;
        for (Object obj : objArray) {
            sbJsonArray.append(Map2JsonConvert.buildJsonValue(obj, ++count != size));
        }
        sbJsonArray.append("]");
        return sbJsonArray.toString();
    }

    private static String buildJsonTail(boolean addComma) {
        return addComma ? "," : "";
    }

    private static String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        return df.format(date);
    }
}

