/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.util;

import com.shadowvc.sdk.EopObject;
import com.shadowvc.sdk.internal.mapping.ApiField;
import com.shadowvc.sdk.internal.util.Map2JsonConvert;
import com.shadowvc.sdk.internal.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class Object2JsonConvert {
    public static String toString(List<?> list, Class<?> clazz) {
        if (EopObject.class.isAssignableFrom(clazz)) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean i = false;
            for (Object obj : list) {
                if (i) {
                    sb.append(",");
                }
                sb.append(Object2JsonConvert.toString(obj));
                i = true;
            }
            sb.append("]");
            return sb.toString();
        }
        return Map2JsonConvert.buildJsonArray(list, false);
    }

    public static String toString(Object object) {
        TreeMap<String, Object> resultMap = new TreeMap<String, Object>();
        Object2JsonConvert.toMap(object, resultMap);
        return Map2JsonConvert.buildJsonBody(resultMap, false);
    }

    private static void toMap(Object object, Map<String, Object> map) {
        if (Map.class.isAssignableFrom(object.getClass())) {
            Object2JsonConvert._toMap((Map)object, map);
        } else {
            Class<?> clazz = object.getClass();
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object value;
                fields[i].setAccessible(true);
                ApiField jsonField = fields[i].getAnnotation(ApiField.class);
                if (jsonField == null) continue;
                String itemName = jsonField.value();
                if (StringUtils.isEmpty(itemName)) {
                    itemName = fields[i].getName();
                }
                try {
                    value = fields[i].get(object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                if (value == null) {
                    map.put(itemName, null);
                    continue;
                }
                Class<?> typeClass = value.getClass();
                if (String.class.isAssignableFrom(typeClass)) {
                    map.put(itemName, value);
                    continue;
                }
                if (Long.class.isAssignableFrom(typeClass)) {
                    map.put(itemName, value);
                    continue;
                }
                if (Integer.class.isAssignableFrom(typeClass)) {
                    map.put(itemName, value);
                    continue;
                }
                if (Boolean.class.isAssignableFrom(typeClass)) {
                    map.put(itemName, value);
                    continue;
                }
                if (Double.class.isAssignableFrom(typeClass)) {
                    map.put(itemName, value);
                    continue;
                }
                if (Number.class.isAssignableFrom(typeClass)) {
                    map.put(itemName, value);
                    continue;
                }
                if (Date.class.isAssignableFrom(typeClass)) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    map.put(itemName, df.format((Date)value));
                    continue;
                }
                if (typeClass.isEnum()) {
                    map.put(itemName, value);
                    continue;
                }
                if (List.class.isAssignableFrom(typeClass)) {
                    Class<?> subType = Object2JsonConvert.getParameterizedType(fields[i], 0);
                    if (EopObject.class.isAssignableFrom(subType)) {
                        Object2JsonConvert.objList(map, itemName, value);
                        continue;
                    }
                    map.put(itemName, value);
                    continue;
                }
                TreeMap<String, Object> _map = new TreeMap<String, Object>();
                map.put(itemName, _map);
                Object2JsonConvert.toMap(value, _map);
            }
        }
    }

    private static void objList(Map<String, Object> map, String itemName, Object value) {
        int size = ((List)value).size();
        LinkedHashSet<TreeMap<String, Object>> _set = new LinkedHashSet<TreeMap<String, Object>>();
        for (int j = 0; j < size; ++j) {
            TreeMap<String, Object> _map = new TreeMap<String, Object>();
            _set.add(_map);
            Object2JsonConvert.toMap(((List)value).get(j), _map);
        }
        map.put(itemName, _set);
    }

    private static void _toMap(Map<?, ?> in, Map<String, Object> out) {
        for (Object key : in.keySet()) {
            Object value = in.get(key);
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            Object2JsonConvert.toMap(value, map);
            out.put((String)key, map);
        }
    }

    private static Class<?> getParameterizedType(Field field, int index) {
        ParameterizedType paramType;
        Type[] genericTypes;
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType && (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) != null && genericTypes.length > 0 && genericTypes[index] instanceof Class) {
            Class subType = (Class)genericTypes[0];
            return subType;
        }
        return null;
    }
}

