/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.util;

import com.shadowvc.sdk.ApiRuleException;
import com.shadowvc.sdk.internal.util.FileItem;
import java.io.IOException;

public class RequestCheckUtils {
    public static final String ERROR_CODE_ARGUMENTS_MISS = "40";
    public static final String ERROR_CODE_ARGUMENTS_INVALID = "41";

    public static void checkNotEmpty(Object value, String fieldName) throws ApiRuleException {
        if (value == null) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISS, "client-error:Missing Required Arguments:" + fieldName + "");
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_MISS, "client-error:Missing Required Arguments:" + fieldName + "");
        }
    }

    public static void checkMaxLength(String value, int maxLength, String fieldName) throws ApiRuleException {
        if (value != null && value.length() > maxLength) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the length of " + fieldName + " can not be larger than " + maxLength + ".");
        }
    }

    public static void checkMaxLength(FileItem fileItem, int maxLength, String fieldName) throws ApiRuleException {
        try {
            if (fileItem != null && fileItem.getContent() != null && fileItem.getContent().length > maxLength) {
                throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the length of " + fieldName + " can not be larger than " + maxLength + ".");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkMaxListSize(String value, int maxSize, String fieldName) throws ApiRuleException {
        String[] list;
        if (value != null && (list = value.split(",")) != null && list.length > maxSize) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the listsize(the string split by \",\") of " + fieldName + " must be less than " + maxSize + ".");
        }
    }

    public static void checkMaxValue(Long value, long maxValue, String fieldName) throws ApiRuleException {
        if (value != null && value > maxValue) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the value of " + fieldName + " can not be larger than " + maxValue + ".");
        }
    }

    public static void checkMinValue(Long value, long minValue, String fieldName) throws ApiRuleException {
        if (value != null && value < minValue) {
            throw new ApiRuleException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the value of " + fieldName + " can not be less than " + minValue + ".");
        }
    }
}

