/*
 * Decompiled with CFR 0.152.
 */
package com.shedhack.thread.context.handler;

import com.google.gson.Gson;
import com.shedhack.thread.context.handler.ThreadContextAfterSet;
import com.shedhack.thread.context.handler.ThreadContextHandler;
import com.shedhack.thread.context.model.DefaultThreadContextModel;
import com.shedhack.thread.context.model.ThreadContextModel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class JsonThreadContextHandler
implements ThreadContextHandler<ThreadContextModel> {
    private static Gson GSON = new Gson();
    private final List<ThreadContextAfterSet> afterHandlers;

    public JsonThreadContextHandler() {
        this.afterHandlers = Collections.EMPTY_LIST;
    }

    public JsonThreadContextHandler(List<ThreadContextAfterSet> afterHandlers) {
        this.afterHandlers = afterHandlers;
    }

    @Override
    public void setThreadContext(ThreadContextModel model) {
        if (model != null) {
            String converted = GSON.toJson((Object)model);
            Thread.currentThread().setName(converted);
            this.afterSettingThreadContext(converted, this.afterHandlers);
        }
    }

    @Override
    public Optional<ThreadContextModel> getThreadContext() {
        return this.convertFromString(Thread.currentThread().getName());
    }

    @Override
    public Optional<ThreadContextModel> convertFromString(String value) {
        try {
            return Optional.ofNullable(GSON.fromJson(value, DefaultThreadContextModel.class));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }
}

