/*
 * Decompiled with CFR 0.152.
 */
package com.shedhack.thread.context.handler;

import com.shedhack.thread.context.handler.ThreadContextAfterSet;
import com.shedhack.thread.context.handler.ThreadContextHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListThreadContextHandler
implements ThreadContextHandler<List<String>> {
    private static final String SEP = "~";
    private final List<ThreadContextAfterSet> afterSetHandlers;

    public ListThreadContextHandler() {
        this.afterSetHandlers = Collections.EMPTY_LIST;
    }

    public ListThreadContextHandler(List<ThreadContextAfterSet> afterSetHandlers) {
        this.afterSetHandlers = afterSetHandlers;
    }

    @Override
    public void setThreadContext(List<String> list) {
        if (list != null && !list.isEmpty()) {
            String converted = list.stream().collect(Collectors.joining(SEP));
            Thread.currentThread().setName(converted);
            this.afterSettingThreadContext(converted, this.afterSetHandlers);
        }
    }

    @Override
    public Optional<List<String>> getThreadContext() {
        return this.convertFromString(Thread.currentThread().getName());
    }

    @Override
    public Optional<List<String>> convertFromString(String original) {
        return Optional.ofNullable(Arrays.asList(original.split(SEP)));
    }
}

