/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.request;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.shift4.enums.PaymentMethodType;
import com.shift4.request.BillingRequest;
import com.shift4.request.FraudCheckDataRequest;
import com.shift4.response.Customer;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PaymentMethodRequest {
    private String id;
    private String customerId;
    private PaymentMethodType type;
    private BillingRequest billing;
    private FraudCheckDataRequest fraudCheckData;
    private ApplePay applePay;
    private ThreeDSecure threeDSecure;
    private GooglePay googlePay;
    private Swish swish;
    private Blik blik;
    private String source;
    private Map<String, String> metadata;
    private String merchantAccountId;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public PaymentMethodRequest() {
    }

    public PaymentMethodRequest(String id) {
        this.id = id;
    }

    public PaymentMethodRequest(PaymentMethodType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public PaymentMethodType getType() {
        return this.type;
    }

    public BillingRequest getBilling() {
        return this.billing;
    }

    public FraudCheckDataRequest getFraudCheckData() {
        return this.fraudCheckData;
    }

    public ApplePay getApplePay() {
        return this.applePay;
    }

    public ThreeDSecure getThreeDSecure() {
        return this.threeDSecure;
    }

    public GooglePay getGooglePay() {
        return this.googlePay;
    }

    public Swish getSwish() {
        return this.swish;
    }

    public Blik getBlik() {
        return this.blik;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public PaymentMethodRequest id(String id) {
        this.id = id;
        return this;
    }

    public PaymentMethodRequest customer(Customer customer) {
        return this.customerId(customer.getId());
    }

    public PaymentMethodRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public PaymentMethodRequest type(PaymentMethodType type) {
        this.type = type;
        return this;
    }

    public PaymentMethodRequest billing(BillingRequest billing) {
        this.billing = billing;
        return this;
    }

    public PaymentMethodRequest fraudCheckData(FraudCheckDataRequest fraudCheckData) {
        this.fraudCheckData = fraudCheckData;
        return this;
    }

    public PaymentMethodRequest applePay(ApplePay applePay) {
        this.applePay = applePay;
        return this;
    }

    public PaymentMethodRequest threeDSecure(ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
        return this;
    }

    public PaymentMethodRequest googlePay(GooglePay googlePay) {
        this.googlePay = googlePay;
        return this;
    }

    public PaymentMethodRequest swish(Swish swish) {
        this.swish = swish;
        return this;
    }

    public PaymentMethodRequest blik(Blik blik) {
        this.blik = blik;
        return this;
    }

    public PaymentMethodRequest source(String source) {
        this.source = source;
        return this;
    }

    public PaymentMethodRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentMethodRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    @JsonAnyGetter
    private Map<String, Object> getOtherMap() {
        return this.other;
    }

    @JsonAnySetter
    public PaymentMethodRequest set(String name, Object value) {
        this.other.put(name, value);
        return this;
    }

    public static class GooglePay {
        private String token;
        @JsonIgnore
        private final Map<String, Object> other = new HashMap<String, Object>();

        public GooglePay(String token) {
            this.token = token;
        }

        public GooglePay() {
        }

        public GooglePay token(String token) {
            this.token = token;
            return this;
        }

        public String getToken() {
            return this.token;
        }

        @JsonAnyGetter
        private Map<String, Object> getOtherMap() {
            return this.other;
        }

        @JsonAnySetter
        public GooglePay set(String name, Object value) {
            this.other.put(name, value);
            return this;
        }
    }

    public static class ThreeDSecure {
        private String currency;
        private Integer amount;
        @JsonIgnore
        private final Map<String, Object> other = new HashMap<String, Object>();

        public ThreeDSecure(String currency, Integer amount) {
            this.currency = currency;
            this.amount = amount;
        }

        public ThreeDSecure() {
        }

        public ThreeDSecure currency(String currency) {
            this.currency = currency;
            return this;
        }

        public ThreeDSecure amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        @JsonAnyGetter
        private Map<String, Object> getOtherMap() {
            return this.other;
        }

        @JsonAnySetter
        public ThreeDSecure set(String name, Object value) {
            this.other.put(name, value);
            return this;
        }
    }

    public static class Blik {
        private String code;
        @JsonIgnore
        private final Map<String, Object> other = new HashMap<String, Object>();

        public Blik code(String code) {
            this.code = code;
            return this;
        }

        public String getCode() {
            return this.code;
        }

        @JsonAnyGetter
        private Map<String, Object> getOtherMap() {
            return this.other;
        }

        @JsonAnySetter
        public Blik set(String name, Object value) {
            this.other.put(name, value);
            return this;
        }
    }

    public static class Swish {
        private SwishLinkMethod linkMethod;
        @JsonIgnore
        private final Map<String, Object> other = new HashMap<String, Object>();

        public Swish(SwishLinkMethod linkMethod) {
            this.linkMethod = linkMethod;
        }

        public SwishLinkMethod getLinkMethod() {
            return this.linkMethod;
        }

        @JsonAnyGetter
        private Map<String, Object> getOtherMap() {
            return this.other;
        }

        @JsonAnySetter
        public Swish set(String name, Object value) {
            this.other.put(name, value);
            return this;
        }

        public static enum SwishLinkMethod {
            APP_REDIRECT,
            PHONE_NUMBER,
            QR_CODE;

        }
    }

    public static class ApplePay {
        private Object token;
        @JsonIgnore
        private final Map<String, Object> other = new HashMap<String, Object>();

        public ApplePay(Object token) {
            this.token = token;
        }

        public ApplePay() {
        }

        public ApplePay token(Object token) {
            this.token = token;
            return this;
        }

        @JsonAnyGetter
        private Map<String, Object> getOtherMap() {
            return this.other;
        }

        @JsonAnySetter
        public ApplePay set(String name, Object value) {
            this.other.put(name, value);
            return this;
        }
    }
}

