/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class StreamCopyRunner
implements Runnable {
    InputStream in;
    OutputStream out;
    private boolean closeStreamAfterConsumingInput;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    StreamCopyRunner(InputStream in, OutputStream out, boolean closeStreamAfterConsumingInput) {
        this.in = in;
        this.out = out;
        this.closeStreamAfterConsumingInput = closeStreamAfterConsumingInput;
    }

    @Override
    public void run() {
        if (this.in == null || this.out == null) {
            return;
        }
        byte[] buffer = new byte[4096];
        try {
            int n;
            while (-1 != (n = this.in.read(buffer))) {
                this.out.write(buffer, 0, n);
            }
            if (this.closeStreamAfterConsumingInput) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("", e);
        }
    }
}

