/*
 * Decompiled with CFR 0.152.
 */
package com.sovren.exceptions;

import com.sovren.models.api.ApiResponseInfo;
import com.sovren.models.api.ApiResponseInfoLite;
import java.util.Optional;
import okhttp3.Response;

public class SovrenException
extends Exception {
    public Response RestResponse;
    public int HttpStatusCode;
    public String SovrenErrorCode;
    public String TransactionId;
    public String RequestBody;
    public Exception InnerException;

    public SovrenException(String requestBody, Response response, ApiResponseInfoLite errorInfo, String transactionId) {
        super(Optional.ofNullable(errorInfo).map(e -> e.Message).orElse("Invalid response object from API"));
        this.RestResponse = response;
        this.HttpStatusCode = Optional.ofNullable(response).map(r -> r.code()).orElse(500);
        this.SovrenErrorCode = Optional.ofNullable(errorInfo).map(e -> e.Code).orElse("Unknown Error");
        this.TransactionId = transactionId;
        this.RequestBody = requestBody;
    }

    public SovrenException(String requestBody, Response response, ApiResponseInfo errorInfo) {
        this(requestBody, response, errorInfo, errorInfo.TransactionId);
    }
}

