/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Table;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class AbstractSqlQueryCommand
extends AbstractDataSourceCommand {
    private String sql = null;
    private OutputFormatType outputFormatType = OutputFormatType.TSV;

    AbstractSqlQueryCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            try (Statement statement = connection.createStatement(1003, 1007);
                 ResultSet resultSet = statement.executeQuery(this.getSql());){
                Table table = new Table();
                table.setDialect(dialect);
                table.readMetaData(connection, resultSet);
                if (this.getOutputFormatType().isTable()) {
                    table.readData(resultSet);
                    this.outputTableData(dialect, table);
                } else {
                    this.outputTableData(dialect, table, resultSet);
                }
            }
        }
        catch (RuntimeException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (IOException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    protected abstract void outputTableData(Dialect var1, Table var2);

    protected abstract void outputTableData(Dialect var1, Table var2, ResultSet var3) throws SQLException, IOException;

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public OutputFormatType getOutputFormatType() {
        return this.outputFormatType;
    }

    public void setOutputFormatType(OutputFormatType outputFormatType) {
        this.outputFormatType = outputFormatType;
    }
}

