/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AbstractHtmlElement
implements Cloneable {
    private String id = null;
    private AbstractHtmlElement parent;
    private List<AbstractHtmlElement> children = new ArrayList<AbstractHtmlElement>();

    protected void add(AbstractHtmlElement element) {
        if (this.children == null) {
            this.children = new ArrayList<AbstractHtmlElement>();
        }
        this.children.add(element);
    }

    protected <T extends AbstractHtmlElement> List<T> getChildren(Class<T> clazz) {
        if (this.children == null) {
            return Collections.emptyList();
        }
        List list = this.children.stream().filter(e -> e != null && clazz.isInstance(e)).map(e -> e).collect(Collectors.toList());
        return list;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder();
        builder.add("id", this.id);
        builder.add("children", this.children);
        this.toString(builder);
        return builder.toString();
    }

    protected void toString(ToStringBuilder builder) {
    }

    public AbstractHtmlElement clone() {
        try {
            AbstractHtmlElement clone = (AbstractHtmlElement)super.clone();
            List cloneChildren = CommonUtils.list();
            for (AbstractHtmlElement child : this.children) {
                cloneChildren.add(child.clone());
            }
            clone.children = cloneChildren;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public List<AbstractHtmlElement> getChildren() {
        return this.children;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setChildren(List<AbstractHtmlElement> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHtmlElement)) {
            return false;
        }
        AbstractHtmlElement other = (AbstractHtmlElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        AbstractHtmlElement this$parent = this.getParent();
        AbstractHtmlElement other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<AbstractHtmlElement> this$children = this.getChildren();
        List<AbstractHtmlElement> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractHtmlElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        AbstractHtmlElement $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<AbstractHtmlElement> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public AbstractHtmlElement getParent() {
        return this.parent;
    }

    protected void setParent(AbstractHtmlElement parent) {
        this.parent = parent;
    }
}

