/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.setting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.setting.ColumnGeneratorSetting;
import com.sqlapp.data.db.command.generator.setting.QueryGeneratorSetting;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.exceptions.ExpressionExecutionException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.eval.CachedEvaluator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class TableGeneratorSetting {
    @JsonProperty(index=0)
    private String name;
    @JsonProperty(index=1)
    private String setupSql;
    @JsonProperty(index=2)
    private String startValueSql;
    @JsonProperty(index=3)
    private long numberOfRows;
    @JsonProperty(index=4)
    private String insertSql;
    @JsonProperty(index=5)
    private String finalizeSql;
    @JsonProperty(index=6)
    private Map<String, ColumnGeneratorSetting> columns = CommonUtils.caseInsensitiveLinkedMap();
    @JsonProperty(index=7)
    private Map<String, QueryGeneratorSetting> querys = new LinkedHashMap<String, QueryGeneratorSetting>();
    @JsonIgnore
    private CachedEvaluator evaluator;
    @JsonIgnore
    private final ParametersContext startValues = new ParametersContext();
    @JsonIgnore
    private final ParametersContext minValues = new ParametersContext();
    @JsonIgnore
    private final ParametersContext maxValues = new ParametersContext();
    @JsonIgnore
    private Map<String, Object> previousValues = Collections.emptyMap();
    @JsonIgnore
    public static final String MIN_KEY = "_min";
    @JsonIgnore
    public static final String MAX_KEY = "_max";
    @JsonIgnore
    public static final String INDEX_KEY = "_index";
    @JsonIgnore
    public static final String ROW_NO_KEY = "_row_number";
    @JsonIgnore
    public static final String PREVIOUS_KEY = "_previous";
    @JsonIgnore
    private long generateCount = 0L;

    public void addColumn(ColumnGeneratorSetting col) {
        this.columns.put(col.getName(), col);
    }

    public void addQueryDefinition(QueryGeneratorSetting obj) {
        this.querys.put(obj.getGenerationGroup(), obj);
    }

    public void check() {
        this.columns.entrySet().forEach(entry -> {
            String genGroup = ((ColumnGeneratorSetting)entry.getValue()).getGenerationGroup();
            if (!CommonUtils.isEmpty((CharSequence)genGroup)) {
                QueryGeneratorSetting queryDef = this.querys.get(genGroup);
                ((ColumnGeneratorSetting)entry.getValue()).setQueryGeneratorSetting(queryDef);
            }
        });
    }

    public synchronized void calculateInitialObjectValues() {
        int i = 1;
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            ColumnGeneratorSetting colSetting = entry.getValue();
            String expression = colSetting.getMinValue();
            ++i;
            if (CommonUtils.isEmpty((CharSequence)expression)) continue;
            try {
                Object value = this.evaluator.getEvalExecutor(expression).eval(Collections.emptyMap());
                colSetting.setMinValueObject(value);
                colSetting.setStartValueObject(value);
                this.minValues.put(colSetting.getName(), value);
                this.startValues.put(colSetting.getName(), value);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column Min Value expression is invalid. column=[F" + i + "]", (Throwable)e);
            }
        }
        this.minValues.remove((Object)"_countSql");
        this.startValues.remove((Object)"_countSql");
        Map map = CommonUtils.map();
        map.put(MIN_KEY, this.minValues);
        i = 1;
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            ColumnGeneratorSetting colSetting = entry.getValue();
            String expression = colSetting.getMaxValue();
            ++i;
            if (CommonUtils.isEmpty((CharSequence)expression)) continue;
            try {
                Object value = this.evaluator.getEvalExecutor(expression).eval((Object)map);
                colSetting.setMaxValueObject(value);
                this.maxValues.put(colSetting.getName(), value);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column Max Value expression is invalid. column=[G" + i + "]", (Throwable)e);
            }
        }
        this.maxValues.remove((Object)"_countSql");
    }

    public void setSqlStartValue(long index, Map<String, Object> map) {
        this.startValues.putAll(this.getPreviousValues());
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            Object converted;
            String key = entry.getKey();
            ColumnGeneratorSetting colSetting = this.columns.get(key);
            Object obj = map.get(key);
            if (obj == null) continue;
            if (colSetting.getMinValueObject() == null) {
                if (colSetting.getMaxValueObject() == null) continue;
                converted = Converters.getDefault().convertObject(obj, colSetting.getMaxValueObject().getClass());
                colSetting.setStartValueObject(converted);
                this.startValues.put(key, converted);
                continue;
            }
            converted = Converters.getDefault().convertObject(obj, colSetting.getMinValueObject().getClass());
            colSetting.setStartValueObject(converted);
            this.startValues.put(key, converted);
        }
        this.generateCount = 0L;
    }

    public Map<String, Object> generateValue(long rowNumber, long index) {
        Map map = CommonUtils.linkedMap();
        map.put(ROW_NO_KEY, rowNumber);
        map.put(INDEX_KEY, index);
        this.previousValues.remove(PREVIOUS_KEY);
        this.previousValues.remove(MIN_KEY);
        this.previousValues.remove(MAX_KEY);
        map.put(MIN_KEY, this.minValues);
        map.put(MAX_KEY, this.maxValues);
        if (this.generateCount == 0L) {
            map.put(PREVIOUS_KEY, this.startValues);
        } else {
            map.put(PREVIOUS_KEY, this.previousValues);
        }
        this.generateInternal(rowNumber, index, map);
        this.previousValues = map;
        ++this.generateCount;
        return map;
    }

    private void generateInternal(long rowNumber, long index, Map<String, Object> map) {
        int intIndex = (int)(rowNumber % Integer.MAX_VALUE);
        int i = 1;
        for (Map.Entry<String, ColumnGeneratorSetting> entry : this.columns.entrySet()) {
            Object value;
            ++i;
            ColumnGeneratorSetting colSetting = entry.getValue();
            if (colSetting.getQueryGeneratorSetting() != null) {
                Map<String, Object> queryValueMap = colSetting.getQueryGeneratorSetting().getValueMap(intIndex);
                map.put(colSetting.getName(), queryValueMap.get(colSetting.getName()));
                continue;
            }
            Optional<Object> op = colSetting.getValue(intIndex);
            if (op.isPresent()) {
                map.put(colSetting.getName(), op.get());
                continue;
            }
            if (CommonUtils.isEmpty((CharSequence)colSetting.getNextValue())) {
                map.put(colSetting.getName(), colSetting.getStartValueObject());
                continue;
            }
            String expression = colSetting.getNextValue();
            try {
                value = this.evaluator.getEvalExecutor(expression).eval(map);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column expression is invalid. column=[H" + i + "]", (Throwable)e);
            }
            if (colSetting.getMaxValueObject() != null) {
                int comp = this.compare(colSetting.getMaxValueObject(), value);
                if (comp > 0) {
                    map.put(colSetting.getName(), value);
                    continue;
                }
                map.put(colSetting.getName(), colSetting.getMinValueObject());
                continue;
            }
            map.put(colSetting.getName(), value);
        }
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass().equals(o2.getClass()) && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        Object o2conv = Converters.getDefault().convertObject(o2, o1.getClass());
        return ((Comparable)o1).compareTo(o2conv);
    }

    public void loadData(Connection conn) throws SQLException {
        for (Map.Entry<String, QueryGeneratorSetting> entry : this.querys.entrySet()) {
            entry.getValue().loadData(conn);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSetupSql() {
        return this.setupSql;
    }

    @Generated
    public String getStartValueSql() {
        return this.startValueSql;
    }

    @Generated
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Generated
    public String getInsertSql() {
        return this.insertSql;
    }

    @Generated
    public String getFinalizeSql() {
        return this.finalizeSql;
    }

    @Generated
    public Map<String, ColumnGeneratorSetting> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, QueryGeneratorSetting> getQuerys() {
        return this.querys;
    }

    @Generated
    public CachedEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public ParametersContext getStartValues() {
        return this.startValues;
    }

    @Generated
    public ParametersContext getMinValues() {
        return this.minValues;
    }

    @Generated
    public ParametersContext getMaxValues() {
        return this.maxValues;
    }

    @Generated
    public Map<String, Object> getPreviousValues() {
        return this.previousValues;
    }

    @Generated
    public long getGenerateCount() {
        return this.generateCount;
    }

    @JsonProperty(index=0)
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(index=1)
    @Generated
    public void setSetupSql(String setupSql) {
        this.setupSql = setupSql;
    }

    @JsonProperty(index=2)
    @Generated
    public void setStartValueSql(String startValueSql) {
        this.startValueSql = startValueSql;
    }

    @JsonProperty(index=3)
    @Generated
    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    @JsonProperty(index=4)
    @Generated
    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }

    @JsonProperty(index=5)
    @Generated
    public void setFinalizeSql(String finalizeSql) {
        this.finalizeSql = finalizeSql;
    }

    @JsonProperty(index=6)
    @Generated
    public void setColumns(Map<String, ColumnGeneratorSetting> columns) {
        this.columns = columns;
    }

    @JsonProperty(index=7)
    @Generated
    public void setQuerys(Map<String, QueryGeneratorSetting> querys) {
        this.querys = querys;
    }

    @JsonIgnore
    @Generated
    public void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @JsonIgnore
    @Generated
    public void setPreviousValues(Map<String, Object> previousValues) {
        this.previousValues = previousValues;
    }

    @JsonIgnore
    @Generated
    public void setGenerateCount(long generateCount) {
        this.generateCount = generateCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableGeneratorSetting)) {
            return false;
        }
        TableGeneratorSetting other = (TableGeneratorSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfRows() != other.getNumberOfRows()) {
            return false;
        }
        if (this.getGenerateCount() != other.getGenerateCount()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$setupSql = this.getSetupSql();
        String other$setupSql = other.getSetupSql();
        if (this$setupSql == null ? other$setupSql != null : !this$setupSql.equals(other$setupSql)) {
            return false;
        }
        String this$startValueSql = this.getStartValueSql();
        String other$startValueSql = other.getStartValueSql();
        if (this$startValueSql == null ? other$startValueSql != null : !this$startValueSql.equals(other$startValueSql)) {
            return false;
        }
        String this$insertSql = this.getInsertSql();
        String other$insertSql = other.getInsertSql();
        if (this$insertSql == null ? other$insertSql != null : !this$insertSql.equals(other$insertSql)) {
            return false;
        }
        String this$finalizeSql = this.getFinalizeSql();
        String other$finalizeSql = other.getFinalizeSql();
        if (this$finalizeSql == null ? other$finalizeSql != null : !this$finalizeSql.equals(other$finalizeSql)) {
            return false;
        }
        Map<String, ColumnGeneratorSetting> this$columns = this.getColumns();
        Map<String, ColumnGeneratorSetting> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, QueryGeneratorSetting> this$querys = this.getQuerys();
        Map<String, QueryGeneratorSetting> other$querys = other.getQuerys();
        if (this$querys == null ? other$querys != null : !((Object)this$querys).equals(other$querys)) {
            return false;
        }
        ParametersContext this$startValues = this.getStartValues();
        ParametersContext other$startValues = other.getStartValues();
        if (this$startValues == null ? other$startValues != null : !this$startValues.equals(other$startValues)) {
            return false;
        }
        ParametersContext this$minValues = this.getMinValues();
        ParametersContext other$minValues = other.getMinValues();
        if (this$minValues == null ? other$minValues != null : !this$minValues.equals(other$minValues)) {
            return false;
        }
        ParametersContext this$maxValues = this.getMaxValues();
        ParametersContext other$maxValues = other.getMaxValues();
        if (this$maxValues == null ? other$maxValues != null : !this$maxValues.equals(other$maxValues)) {
            return false;
        }
        Map<String, Object> this$previousValues = this.getPreviousValues();
        Map<String, Object> other$previousValues = other.getPreviousValues();
        return !(this$previousValues == null ? other$previousValues != null : !((Object)this$previousValues).equals(other$previousValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableGeneratorSetting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $numberOfRows = this.getNumberOfRows();
        result = result * 59 + (int)($numberOfRows >>> 32 ^ $numberOfRows);
        long $generateCount = this.getGenerateCount();
        result = result * 59 + (int)($generateCount >>> 32 ^ $generateCount);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $setupSql = this.getSetupSql();
        result = result * 59 + ($setupSql == null ? 43 : $setupSql.hashCode());
        String $startValueSql = this.getStartValueSql();
        result = result * 59 + ($startValueSql == null ? 43 : $startValueSql.hashCode());
        String $insertSql = this.getInsertSql();
        result = result * 59 + ($insertSql == null ? 43 : $insertSql.hashCode());
        String $finalizeSql = this.getFinalizeSql();
        result = result * 59 + ($finalizeSql == null ? 43 : $finalizeSql.hashCode());
        Map<String, ColumnGeneratorSetting> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, QueryGeneratorSetting> $querys = this.getQuerys();
        result = result * 59 + ($querys == null ? 43 : ((Object)$querys).hashCode());
        ParametersContext $startValues = this.getStartValues();
        result = result * 59 + ($startValues == null ? 43 : $startValues.hashCode());
        ParametersContext $minValues = this.getMinValues();
        result = result * 59 + ($minValues == null ? 43 : $minValues.hashCode());
        ParametersContext $maxValues = this.getMaxValues();
        result = result * 59 + ($maxValues == null ? 43 : $maxValues.hashCode());
        Map<String, Object> $previousValues = this.getPreviousValues();
        result = result * 59 + ($previousValues == null ? 43 : ((Object)$previousValues).hashCode());
        return result;
    }
}

