/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.ConvertHandler;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ExceptionHandler;
import com.sqlapp.util.JsonConverter;
import com.sqlapp.util.ToRuntimeExceptionHandler;
import java.io.PrintStream;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCommand.class);
    private ExceptionHandler exceptionHandler = new ToRuntimeExceptionHandler();
    private ConvertHandler convertHandler = new ConvertHandler(this);
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private Map<String, Object> context = CommonUtils.linkedMap();
    private Converters converters = Converters.getDefault();

    protected JsonConverter createJsonConverter() {
        JsonConverter jsonConverter = new JsonConverter();
        jsonConverter.setIndentOutput(true);
        return jsonConverter;
    }

    @Override
    public void run() {
        this.initialize();
        this.doRun();
    }

    protected void initialize() {
        this.initializeContext();
    }

    protected void initializeContext() {
        this.context.putAll(System.getenv());
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.context.put(this.converters.convertString(k), this.converters.convertString(v))));
    }

    protected abstract void doRun();

    private PrintStream getOut() {
        return this.out;
    }

    protected void println(Object obj) {
        if (obj != null) {
            this.getOut().println(obj.toString());
        }
    }

    protected PrintStream getErr() {
        return this.err;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ConvertHandler getConvertHandler() {
        return this.convertHandler;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setConvertHandler(ConvertHandler convertHandler) {
        this.convertHandler = convertHandler;
        if (this.convertHandler != null) {
            this.convertHandler.setCommand(this);
        }
    }
}

