/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.html.CustomParserContextFactory;
import com.sqlapp.data.db.command.html.HighlightMethod;
import com.sqlapp.data.db.command.html.HtmlUtils;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.mvel2.ParserContext;

public class RenderOptions {
    private String cdnScheme = "https:";
    private String tableClass = "outline-header border box-header outline";
    private ParserContext parserContext = new CustomParserContextFactory().getParserContext();
    private HighlightMethod highlightMethod = HighlightMethod.Prism;
    private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private String checkIconValue = "<span class=\"icon icon-16 icon-check-sign\"/>";
    private String cssFrameworkPath = "//cdnjs.cloudflare.com/ajax/libs/cascade-framework/1.5.0/css/build-full.min.css";
    private boolean withJquery = true;
    private boolean withRows = true;
    private String[] hideColumns = new String[]{SchemaProperties.REMARKS.getLabel(), SchemaProperties.DISPLAY_REMARKS.getLabel(), SchemaProperties.SPECIFICS.getLabel(), SchemaProperties.STATISTICS.getLabel(), SchemaProperties.CREATED_AT.getLabel(), SchemaProperties.LAST_ALTERED_AT.getLabel()};
    private Set<String> hideColumnsSet = null;

    public String formatDateTime(Object obj) {
        if (obj == null) {
            return "";
        }
        return DateUtils.format((Date)((Date)obj), (String)this.dateTimeFormat);
    }

    public String checkIcon(Object obj) {
        if (obj == null) {
            return "";
        }
        Boolean bool = (Boolean)Converters.getDefault().convertObject(obj, Boolean.class);
        if (bool != null && bool.booleanValue()) {
            return this.checkIconValue;
        }
        return "";
    }

    public String tableHeaderColAttr(String ... args) {
        return this.tableBodyColAttr(args);
    }

    public String tableBodyColAttr(String ... args) {
        StringBuilder builder = new StringBuilder();
        StringBuilder childBuilder = new StringBuilder();
        for (String arg : args) {
            childBuilder.append("_col_" + this.convertName(arg) + "_");
            childBuilder.append(' ');
        }
        builder.append(HtmlUtils.attr("class", childBuilder.substring(0, childBuilder.length() - 1)));
        if (this.isHideTarget(args)) {
            builder.append(" ");
            builder.append(HtmlUtils.attr("style", "display: none;"));
        }
        return builder.toString();
    }

    private boolean isHideTarget(String ... args) {
        for (String arg : args) {
            if (!this.getHideColumnsSet().contains(arg)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getHideColumnsSet() {
        if (this.hideColumnsSet == null) {
            this.hideColumnsSet = CommonUtils.lowerSet();
            for (String arg : this.hideColumns) {
                this.hideColumnsSet.add(arg);
            }
        }
        return this.hideColumnsSet;
    }

    private String convertName(String name) {
        if ("#".equals(name)) {
            return "sharp";
        }
        return name.replace(" ", "");
    }

    public String getLanguage(Object obj) {
        return this.getHighlightMethod().getLanguage(obj);
    }

    public String[] getHighlightJs() {
        return this.getHighlightMethod().getJs();
    }

    public String[] getHighlightCss() {
        return this.getHighlightMethod().getCss();
    }

    public String getHighlightPreClass() {
        return this.getHighlightMethod().getPreClass();
    }

    public String loadInitScript() {
        return this.getHighlightMethod().loadInitScript();
    }

    public String getCdnScheme() {
        return this.cdnScheme;
    }

    public String getTableClass() {
        return this.tableClass;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public HighlightMethod getHighlightMethod() {
        return this.highlightMethod;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getCheckIconValue() {
        return this.checkIconValue;
    }

    public String getCssFrameworkPath() {
        return this.cssFrameworkPath;
    }

    public boolean isWithJquery() {
        return this.withJquery;
    }

    public boolean isWithRows() {
        return this.withRows;
    }

    public String[] getHideColumns() {
        return this.hideColumns;
    }

    public void setCdnScheme(String cdnScheme) {
        this.cdnScheme = cdnScheme;
    }

    public void setTableClass(String tableClass) {
        this.tableClass = tableClass;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void setHighlightMethod(HighlightMethod highlightMethod) {
        this.highlightMethod = highlightMethod;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setCheckIconValue(String checkIconValue) {
        this.checkIconValue = checkIconValue;
    }

    public void setCssFrameworkPath(String cssFrameworkPath) {
        this.cssFrameworkPath = cssFrameworkPath;
    }

    public void setWithJquery(boolean withJquery) {
        this.withJquery = withJquery;
    }

    public void setWithRows(boolean withRows) {
        this.withRows = withRows;
    }

    public void setHideColumns(String[] hideColumns) {
        this.hideColumns = hideColumns;
    }

    public void setHideColumnsSet(Set<String> hideColumnsSet) {
        this.hideColumnsSet = hideColumnsSet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderOptions)) {
            return false;
        }
        RenderOptions other = (RenderOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cdnScheme = this.getCdnScheme();
        String other$cdnScheme = other.getCdnScheme();
        if (this$cdnScheme == null ? other$cdnScheme != null : !this$cdnScheme.equals(other$cdnScheme)) {
            return false;
        }
        String this$tableClass = this.getTableClass();
        String other$tableClass = other.getTableClass();
        if (this$tableClass == null ? other$tableClass != null : !this$tableClass.equals(other$tableClass)) {
            return false;
        }
        ParserContext this$parserContext = this.getParserContext();
        ParserContext other$parserContext = other.getParserContext();
        if (this$parserContext == null ? other$parserContext != null : !this$parserContext.equals(other$parserContext)) {
            return false;
        }
        HighlightMethod this$highlightMethod = this.getHighlightMethod();
        HighlightMethod other$highlightMethod = other.getHighlightMethod();
        if (this$highlightMethod == null ? other$highlightMethod != null : !((Object)((Object)this$highlightMethod)).equals((Object)other$highlightMethod)) {
            return false;
        }
        String this$dateTimeFormat = this.getDateTimeFormat();
        String other$dateTimeFormat = other.getDateTimeFormat();
        if (this$dateTimeFormat == null ? other$dateTimeFormat != null : !this$dateTimeFormat.equals(other$dateTimeFormat)) {
            return false;
        }
        String this$checkIconValue = this.getCheckIconValue();
        String other$checkIconValue = other.getCheckIconValue();
        if (this$checkIconValue == null ? other$checkIconValue != null : !this$checkIconValue.equals(other$checkIconValue)) {
            return false;
        }
        String this$cssFrameworkPath = this.getCssFrameworkPath();
        String other$cssFrameworkPath = other.getCssFrameworkPath();
        if (this$cssFrameworkPath == null ? other$cssFrameworkPath != null : !this$cssFrameworkPath.equals(other$cssFrameworkPath)) {
            return false;
        }
        if (this.isWithJquery() != other.isWithJquery()) {
            return false;
        }
        if (this.isWithRows() != other.isWithRows()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHideColumns(), other.getHideColumns())) {
            return false;
        }
        Set<String> this$hideColumnsSet = this.getHideColumnsSet();
        Set<String> other$hideColumnsSet = other.getHideColumnsSet();
        return !(this$hideColumnsSet == null ? other$hideColumnsSet != null : !((Object)this$hideColumnsSet).equals(other$hideColumnsSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cdnScheme = this.getCdnScheme();
        result = result * 59 + ($cdnScheme == null ? 43 : $cdnScheme.hashCode());
        String $tableClass = this.getTableClass();
        result = result * 59 + ($tableClass == null ? 43 : $tableClass.hashCode());
        ParserContext $parserContext = this.getParserContext();
        result = result * 59 + ($parserContext == null ? 43 : $parserContext.hashCode());
        HighlightMethod $highlightMethod = this.getHighlightMethod();
        result = result * 59 + ($highlightMethod == null ? 43 : ((Object)((Object)$highlightMethod)).hashCode());
        String $dateTimeFormat = this.getDateTimeFormat();
        result = result * 59 + ($dateTimeFormat == null ? 43 : $dateTimeFormat.hashCode());
        String $checkIconValue = this.getCheckIconValue();
        result = result * 59 + ($checkIconValue == null ? 43 : $checkIconValue.hashCode());
        String $cssFrameworkPath = this.getCssFrameworkPath();
        result = result * 59 + ($cssFrameworkPath == null ? 43 : $cssFrameworkPath.hashCode());
        result = result * 59 + (this.isWithJquery() ? 79 : 97);
        result = result * 59 + (this.isWithRows() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getHideColumns());
        Set<String> $hideColumnsSet = this.getHideColumnsSet();
        result = result * 59 + ($hideColumnsSet == null ? 43 : ((Object)$hideColumnsSet).hashCode());
        return result;
    }

    public String toString() {
        return "RenderOptions(cdnScheme=" + this.getCdnScheme() + ", tableClass=" + this.getTableClass() + ", parserContext=" + this.getParserContext() + ", highlightMethod=" + (Object)((Object)this.getHighlightMethod()) + ", dateTimeFormat=" + this.getDateTimeFormat() + ", checkIconValue=" + this.getCheckIconValue() + ", cssFrameworkPath=" + this.getCssFrameworkPath() + ", withJquery=" + this.isWithJquery() + ", withRows=" + this.isWithRows() + ", hideColumns=" + Arrays.deepToString(this.getHideColumns()) + ", hideColumnsSet=" + this.getHideColumnsSet() + ")";
    }
}

