/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSqlCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SqlExecuteCommand
extends AbstractSqlCommand {
    private Collection<File> sqlFiles = null;
    private Collection<String> sqlText = null;

    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            Dialect dialect = this.getDialect(connection);
            SqlSplitter sqlSplitter = dialect.createSqlSplitter();
            SqlConverter sqlConverter = this.getSqlConverter();
            if (!CommonUtils.isEmpty(this.getSqlFiles())) {
                for (File file : this.getSqlFiles()) {
                    File[] children;
                    if (!file.exists()) continue;
                    if (file.isFile()) {
                        this.executeSql(sqlSplitter, sqlConverter, dialect, connection, file);
                        continue;
                    }
                    if (!file.isDirectory() || (children = file.listFiles()) == null) continue;
                    for (File child : children) {
                        this.executeSql(sqlSplitter, sqlConverter, dialect, connection, child);
                    }
                }
            }
            if (!CommonUtils.isEmpty(this.getSqlText())) {
                for (String text : this.getSqlText()) {
                    ParametersContext context = new ParametersContext();
                    context.putAll(this.getContext());
                    List sqls = sqlSplitter.parse(text);
                    for (SqlSplitter.SplitResult splitResult : sqls) {
                        this.executeSql(sqlConverter, dialect, connection, splitResult);
                    }
                }
            }
            connection.commit();
        }
        catch (RuntimeException e) {
            this.rollback(connection);
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    private void executeSql(SqlSplitter sqlSplitter, SqlConverter sqlConverter, Dialect dialect, Connection connection, File file) {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        String text = FileUtils.readText((File)file, (String)this.getEncoding());
        List sqls = sqlSplitter.parse(text);
        for (SqlSplitter.SplitResult splitResult : sqls) {
            this.executeSql(sqlConverter, dialect, connection, splitResult);
        }
    }

    private void executeSql(SqlConverter sqlConverter, Dialect dialect, Connection connection, SqlSplitter.SplitResult splitResult) {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        SqlNode sqlNode = sqlConverter.parseSql(context, splitResult.getText());
        JdbcHandler jdbcHandler = dialect.createJdbcHandler(sqlNode);
        jdbcHandler.execute(connection, context);
    }

    protected Collection<File> getSqlFiles() {
        return this.sqlFiles;
    }

    public void setSqlFiles(Collection<File> sqlFiles) {
        this.sqlFiles = sqlFiles;
    }

    public void setSqlFiles(File ... sqlFiles) {
        this.sqlFiles = CommonUtils.isEmpty((Object)sqlFiles) ? Collections.emptyList() : CommonUtils.list((Object[])sqlFiles);
    }

    public void setSqlFiles(String ... sqlFiles) {
        if (CommonUtils.isEmpty((Object)sqlFiles)) {
            this.sqlFiles = Collections.emptyList();
        } else {
            this.sqlFiles = CommonUtils.list();
            for (String sqlPath : sqlFiles) {
                this.sqlFiles.add(new File(sqlPath));
            }
        }
    }

    protected Collection<String> getSqlText() {
        return this.sqlText;
    }

    public void setSqlText(Collection<String> sqlText) {
        this.sqlText = sqlText;
    }

    public void setSqlText(String ... args) {
        if (CommonUtils.isEmpty((Object)args)) {
            this.sqlText = Collections.emptyList();
        } else {
            this.sqlText = CommonUtils.list();
            for (String arg : args) {
                if (CommonUtils.isEmpty((CharSequence)arg)) continue;
                this.sqlText.add(arg);
            }
        }
    }
}

