/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresViewColumnReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.View;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresViewReader
extends ViewReader {
    protected PostgresViewReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = PostgresViewReader.this.createTable(rs);
                result.add(table);
            }
        });
        return result;
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        String comments = this.getString((ResultSet)rs, "remarks");
        View table = this.createTable(this.getString((ResultSet)rs, "table_name"));
        table.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        table.setRemarks(comments);
        table.setStatement(this.getString((ResultSet)rs, "definition"));
        return table;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("views.sql");
    }

    protected ColumnReader newColumnReader() {
        return new PostgresViewColumnReader(this.getDialect());
    }

    protected IndexReader newIndexReader() {
        return null;
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

