/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.db.dialect.postgres.util.PostgresIndexOptions;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractCreateIndexFactory;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Map;

public class PostgresCreateIndexFactory
extends AbstractCreateIndexFactory<PostgresSqlBuilder> {
    public void addCreateObject(Index obj, PostgresSqlBuilder builder) {
        super.addCreateObject(obj, (AbstractSqlBuilder)builder);
        this.addObjectDetailAfter(obj, obj.getTable(), builder);
    }

    protected void addUnique(Index obj, Table table, PostgresSqlBuilder builder) {
        ((PostgresSqlBuilder)builder.unique(obj.isUnique())).index();
        boolean conc = table != null && this.getOptions().getTableOptions().getOnlineIndex().test((Object)table, (Object)obj);
        builder.concurrently(conc);
        ((PostgresSqlBuilder)builder.ifNotExists(table != null && this.getOptions().isCreateIfNotExists())).space();
    }

    public void addObjectDetail(Index obj, Table table, PostgresSqlBuilder builder) {
        super.addObjectDetail(obj, table, (AbstractSqlBuilder)builder);
        this.addWith(obj, table, builder);
        this.addFilter(obj, table, builder);
    }

    protected void addObjectDetailAfter(Index obj, Table table, PostgresSqlBuilder builder) {
        this.addIncludes(obj, table, builder);
        this.addIncludesAfter(obj, table, builder);
    }

    protected void addIncludes(Index obj, Table table, PostgresSqlBuilder builder) {
    }

    protected void addIncludesAfter(Index obj, Table table, PostgresSqlBuilder builder) {
    }

    protected void addWith(Index obj, Table table, PostgresSqlBuilder builder) {
        Map<String, String> map = this.createIndexWithOption(obj, table);
        if (map.isEmpty()) {
            return;
        }
        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).with()).space()).brackets(() -> {
            builder.indent(() -> {
                boolean[] first = new boolean[]{true};
                map.forEach((k, v) -> {
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).comma(!first[0]))._add((String)k)).eq()).space())._add((String)v);
                    first[0] = false;
                });
            });
            builder.lineBreak();
        });
    }

    protected Map<String, String> createIndexWithOption(Index obj, Table table) {
        Map map = CommonUtils.linkedMap();
        String key = PostgresIndexOptions.FILLFACTOR.toString();
        String val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = PostgresIndexOptions.BUFFERING.toString();
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = PostgresIndexOptions.FASTUPDATE.toString();
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = PostgresIndexOptions.GIN_PENDING_LIST_LIMIT.toString();
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = PostgresIndexOptions.PAGE_PER_RANGE.toString();
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        key = PostgresIndexOptions.AUTOSUMMARISE.toString();
        val = obj.getSpecifics().get(key);
        if (val != null) {
            map.put(key, val);
        }
        return map;
    }

    protected void addFilter(Index obj, Table table, PostgresSqlBuilder builder) {
        if (!CommonUtils.isEmpty((CharSequence)obj.getWhere())) {
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).where()).space())._add(obj.getWhere());
        }
    }

    protected void addColumn(ReferenceColumn col, PostgresSqlBuilder builder) {
        builder.name((AbstractNamedObject)col);
        if (col.getOrder() != null && col.getOrder() != Order.Asc) {
            ((PostgresSqlBuilder)builder.space())._add((EnumProperties)col.getOrder());
        }
        if (col.getNullsOrder() != null) {
            ((PostgresSqlBuilder)builder.space())._add((EnumProperties)col.getNullsOrder());
        }
    }
}

