/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.DialectHolder;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;

public class PostgresDialectResolver
extends ProductNameDialectResolver {
    public static final PostgresDialectResolver instance = new PostgresDialectResolver();

    public PostgresDialectResolver() {
        super("Postgres.*", (VersionResolver)new PostgresVersionResolver());
    }

    public static PostgresDialectResolver getInstance() {
        return instance;
    }

    public static class PostgresVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            if (majorVersion >= 16) {
                return DialectHolder.postgreSQL160;
            }
            if (majorVersion >= 15) {
                return DialectHolder.postgreSQL150;
            }
            if (majorVersion >= 14) {
                return DialectHolder.postgreSQL140;
            }
            if (majorVersion >= 13) {
                return DialectHolder.postgreSQL130;
            }
            if (majorVersion >= 12) {
                return DialectHolder.postgreSQL120;
            }
            if (majorVersion >= 11) {
                return DialectHolder.postgreSQL110;
            }
            if (majorVersion >= 10) {
                return DialectHolder.postgreSQL100;
            }
            if (majorVersion >= 9) {
                switch (minorVersion) {
                    case 0: {
                        return DialectHolder.postgreSQL90;
                    }
                    case 1: {
                        return DialectHolder.postgreSQL91;
                    }
                    case 2: {
                        return DialectHolder.postgreSQL92;
                    }
                    case 3: {
                        return DialectHolder.postgreSQL93;
                    }
                    case 4: {
                        return DialectHolder.postgreSQL94;
                    }
                    case 5: {
                        return DialectHolder.postgreSQL95;
                    }
                    case 6: {
                        return DialectHolder.postgreSQL96;
                    }
                }
                return DialectHolder.postgreSQL90;
            }
            if (majorVersion >= 8) {
                switch (minorVersion) {
                    case 0: {
                        return DialectHolder.defaultDialect;
                    }
                    case 1: {
                        return DialectHolder.defaultDialect;
                    }
                    case 2: {
                        return DialectHolder.postgreSQL82;
                    }
                    case 3: {
                        return DialectHolder.postgreSQL83;
                    }
                    case 4: {
                        return DialectHolder.postgreSQL84;
                    }
                }
                return DialectHolder.defaultDialect;
            }
            return DialectHolder.defaultDialect;
        }
    }
}

