/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.OperatorFamilyReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.OperatorFamily;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class Postgres83OperatorFamilyReader
extends OperatorFamilyReader {
    protected Postgres83OperatorFamilyReader(Dialect dialect) {
        super(dialect);
    }

    protected List<OperatorFamily> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                OperatorFamily obj = Postgres83OperatorFamilyReader.this.createOperatorFamily(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("operatorFamilies83.sql");
    }

    protected OperatorFamily createOperatorFamily(ExResultSet rs) throws SQLException {
        OperatorFamily obj = new OperatorFamily();
        obj.setDialect(this.getDialect());
        obj.setStrategyNumber(rs.getInt("operator_family_strategy"));
        obj.setOperatorClassName(this.getString((ResultSet)rs, "operator_class_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setOperatorName(this.getString((ResultSet)rs, "operator_name"));
        obj.getOperator().setSchemaName(this.getString((ResultSet)rs, "operator_schema"));
        obj.getOperator().setLeftArgument(this.getString((ResultSet)rs, "left_type"));
        obj.getOperator().setRightArgument(this.getString((ResultSet)rs, "right_type"));
        return obj;
    }
}

