/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresUtils;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresColumnReader
extends ColumnReader {
    protected PostgresColumnReader(Dialect dialect) {
        super(dialect);
    }

    protected String getType() {
        return "r";
    }

    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        context.put("relkind", (Object)this.getType());
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Column column = PostgresColumnReader.this.createColumn(rs);
                result.add(column);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columns.sql");
    }

    protected Column createColumn(ExResultSet rs) throws SQLException {
        Column column = new Column();
        column.setDialect(this.getDialect());
        PostgresUtils.setColumnMetadata((ResultSet)rs, this.getDialect(), column);
        column.setTableName(this.getString((ResultSet)rs, "relname"));
        return column;
    }
}

