/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresCheckConstraintReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresColumnReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresForeignKeyConstraintReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresIndexReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresUniqueConstraintReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Statistics;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresTableReader
extends TableReader {
    private String[] relkind = new String[]{"r"};

    protected PostgresTableReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        ParametersContext clone = context.clone();
        if (!CommonUtils.isEmpty((Object)this.relkind)) {
            clone.put("relkind", (Object)this.relkind);
        }
        final List result = CommonUtils.list();
        this.execute(connection, node, clone, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = PostgresTableReader.this.createTable(rs);
                result.add(table);
            }
        });
        return result;
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        Table obj = this.createTable(this.getString((ResultSet)rs, "table_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        obj.setId(this.getString((ResultSet)rs, "table_id"));
        this.setSpecifics((ResultSet)rs, "relhasoids", "oids", (SpecificsProperty)obj);
        Statistics.ROWS.setValue(rs, "n_live_tup", (StatisticsProperty)obj);
        Statistics.DATA_LENGTH.setValue(rs, "data_length", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "seq_scan", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "seq_tup_read", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "idx_scan", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "idx_tup_fetch", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "n_tup_ins", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "n_tup_upd", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "n_tup_del", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "n_tup_hot_upd", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "n_dead_tup", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "n_mod_since_analyze", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "last_vacuum", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "last_autovacuum", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "last_analyze", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "last_autoanalyze", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "vacuum_count", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "autovacuum_count", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "analyze_count", (StatisticsProperty)obj);
        this.setStatistics((ResultSet)rs, "autoanalyze_count", (StatisticsProperty)obj);
        return obj;
    }

    protected void setMetadataDetail(Connection connection, ParametersContext context, List<Table> list) throws SQLException {
        super.setMetadataDetail(connection, context, list);
        if (list.isEmpty()) {
            return;
        }
        SqlNode node = this.getInheritsSqlSqlNode();
        final DoubleKeyMap keyMap = SchemaUtils.toDoubleKeyMap(list);
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String psName = this.getString(rs, "parent_schema_name");
                String ptName = this.getString(rs, "parent_table_name");
                Table table = (Table)keyMap.get((Object)this.getString(rs, "schema_name"), (Object)this.getString(rs, "table_name"));
                Table pTable = (Table)keyMap.get((Object)psName, (Object)ptName);
                if (pTable == null) {
                    pTable = (Table)new Table(ptName).setSchemaName(psName);
                }
                table.getInherits().add((AbstractNamedObject)pTable);
            }
        });
    }

    public void setRelkind(String ... relkind) {
        this.relkind = relkind;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables.sql");
    }

    protected SqlNode getInheritsSqlSqlNode() {
        return this.getSqlNodeCache().getString("inherits.sql");
    }

    protected ColumnReader newColumnReader() {
        return new PostgresColumnReader(this.getDialect());
    }

    protected IndexReader newIndexReader() {
        return new PostgresIndexReader(this.getDialect());
    }

    protected UniqueConstraintReader newUniqueConstraintReader() {
        return new PostgresUniqueConstraintReader(this.getDialect());
    }

    protected CheckConstraintReader newCheckConstraintReader() {
        return new PostgresCheckConstraintReader(this.getDialect());
    }

    protected ForeignKeyConstraintReader newForeignKeyConstraintReader() {
        return new PostgresForeignKeyConstraintReader(this.getDialect());
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

