/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.Postgres90ExcludeConstraintReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresColumnReader;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresIndexReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.MviewReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Mview;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class Postgres93MviewReader
extends MviewReader {
    protected Postgres93MviewReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = Postgres93MviewReader.this.createTable(rs);
                result.add(table);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("mviews.sql");
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        Mview table = this.createTable(this.getString((ResultSet)rs, "matviewname"));
        table.setSchemaName(this.getString((ResultSet)rs, "schemaname"));
        table.setTableSpaceName(this.getString((ResultSet)rs, "tablespace"));
        table.setRemarks("remarks");
        table.setStatement(this.getString((ResultSet)rs, "definition"));
        return table;
    }

    protected void setMetadataDetail(Connection connection, Table table) throws SQLException {
    }

    protected ColumnReader newColumnReader() {
        return new PostgresColumnReader(this.getDialect());
    }

    protected IndexReader newIndexReader() {
        return new PostgresIndexReader(this.getDialect());
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return new Postgres90ExcludeConstraintReader(this.getDialect());
    }
}

