/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ColumnPrivilege;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresColumnPrivilegeReader
extends ColumnPrivilegeReader {
    protected PostgresColumnPrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ColumnPrivilege> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                ColumnPrivilege obj = PostgresColumnPrivilegeReader.this.createColumnPrivilege(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columnPrivileges.sql");
    }

    protected ColumnPrivilege createColumnPrivilege(ExResultSet rs) throws SQLException {
        ColumnPrivilege obj = new ColumnPrivilege();
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "table_schema"));
        obj.setObjectName(this.getString((ResultSet)rs, "table_name"));
        obj.setGrantorName(this.getString((ResultSet)rs, "grantor"));
        obj.setGranteeName(this.getString((ResultSet)rs, "grantee"));
        obj.setColumnName(this.getString((ResultSet)rs, "column_name"));
        obj.setPrivilege(this.getString((ResultSet)rs, "privilege_type"));
        obj.setGrantable("YES".equals(this.getString((ResultSet)rs, "is_grantable")));
        return obj;
    }
}

