/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresDomainReader
extends DomainReader {
    protected PostgresDomainReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Domain> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Domain obj = PostgresDomainReader.this.createDomain(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("domains.sql");
    }

    protected Domain createDomain(ExResultSet rs) throws SQLException {
        String productDataType = this.getString((ResultSet)rs, "typname");
        int arrayDimension = rs.getInt("typndims");
        String intervalTypeName = this.getString((ResultSet)rs, "interval_type_name");
        if (arrayDimension > 0) {
            productDataType = CommonUtils.ltrim((String)productDataType, (char)'_');
        }
        productDataType = CommonUtils.notEmpty((String)intervalTypeName, (String)productDataType);
        Long maxLength = this.getLong((ResultSet)rs, "max_length");
        Long numericPrecision = this.getLong((ResultSet)rs, "numeric_precision");
        Integer numericScale = this.getInt((ResultSet)rs, "numeric_scale");
        Integer datetimeScale = this.getInt((ResultSet)rs, "datetime_scale");
        Integer intervalScale = this.getInt((ResultSet)rs, "interval_scale");
        Domain obj = new Domain(this.getString((ResultSet)rs, "domain_name"));
        obj.setNullable(!rs.getBoolean("typnotnull"));
        this.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{maxLength, numericPrecision}), CommonUtils.notZero((Integer[])new Integer[]{numericScale, datetimeScale, intervalScale}), (DataTypeLengthProperties)obj);
        obj.setId(this.getString((ResultSet)rs, "oid"));
        obj.setSchemaName(this.getString((ResultSet)rs, "domain_schema"));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        obj.setArrayDimension(arrayDimension);
        obj.setDefaultValue(this.getString((ResultSet)rs, "typdefault"));
        obj.setCheck(this.getString((ResultSet)rs, "consrc"));
        boolean is_deferrable = rs.getBoolean("is_deferrable");
        boolean initially_deferred = rs.getBoolean("initially_deferred");
        obj.setDeferrability(Deferrability.getDeferrability((boolean)is_deferrable, (boolean)initially_deferred));
        return obj;
    }
}

