/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresUtils;
import com.sqlapp.data.db.metadata.RoutinePrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.RoutinePrivilege;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresRoutinePrivilegeReader
extends RoutinePrivilegeReader {
    protected PostgresRoutinePrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<RoutinePrivilege> doGetAll(final Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                RoutinePrivilege obj = PostgresRoutinePrivilegeReader.this.createPrivilege(connection, rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("routinePrivileges.sql");
    }

    protected RoutinePrivilege createPrivilege(Connection connection, ExResultSet rs) throws SQLException {
        String allArgTypes;
        RoutinePrivilege obj = new RoutinePrivilege();
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "ROUTINE_SCHEMA"));
        obj.setObjectName(this.getString((ResultSet)rs, "routine_name"));
        obj.setPrivilege(this.getString((ResultSet)rs, "privilege_type"));
        obj.setGrantorName(this.getString((ResultSet)rs, "grantor"));
        obj.setGranteeName(this.getString((ResultSet)rs, "grantee"));
        obj.setGrantable("YES".equals(this.getString((ResultSet)rs, "IS_GRANTABLE")));
        obj.setHierachy("YES".equals(this.getString((ResultSet)rs, "WITH_HIERARCHY")));
        int argNo = rs.getInt("pronargs");
        Function function = new Function(this.getString((ResultSet)rs, "routine_name"));
        if (argNo > 0 && (allArgTypes = CommonUtils.unwrap((String)rs.getString("proargtypes"), (String)"{", (String)"}")) != null) {
            String[] argArray = CommonUtils.split((String)allArgTypes, (String)"[, ]");
            SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
            List<NamedArgument> arguments = PostgresUtils.getTypeInfoById(connection, this.getDialect(), argArray);
            for (NamedArgument argument : arguments) {
                builder.add((Object)argument.getDataTypeName());
            }
            obj.setSpecificName(function.getName() + "(" + builder.toString() + ")");
        }
        return obj;
    }
}

