/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.dialect.Postgres;
import com.sqlapp.data.db.dialect.Postgres100;
import com.sqlapp.data.db.dialect.Postgres110;
import com.sqlapp.data.db.dialect.Postgres120;
import com.sqlapp.data.db.dialect.Postgres83;
import com.sqlapp.data.db.dialect.Postgres84;
import com.sqlapp.data.db.dialect.Postgres90;
import com.sqlapp.data.db.dialect.Postgres91;
import com.sqlapp.data.db.dialect.Postgres92;
import com.sqlapp.data.db.dialect.Postgres93;
import com.sqlapp.data.db.dialect.Postgres94;
import com.sqlapp.data.db.dialect.Postgres95;
import com.sqlapp.data.db.dialect.Postgres96;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;

public class PostgresDialectResolver
extends ProductNameDialectResolver {
    private static final long serialVersionUID = 1L;

    public PostgresDialectResolver() {
        super("Postgres.*", (VersionResolver)new PostgresVersionResolver());
    }

    public static class PostgresVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            switch (majorVersion) {
                case 6: 
                case 7: 
                case 8: {
                    switch (minorVersion) {
                        case 0: {
                            return DialectHolder.defaultDialect;
                        }
                        case 1: {
                            return DialectHolder.defaultDialect;
                        }
                        case 2: {
                            return DialectHolder.postgreSQL82;
                        }
                        case 3: {
                            return DialectHolder.postgreSQL83;
                        }
                        case 4: {
                            return DialectHolder.postgreSQL84;
                        }
                    }
                    return DialectHolder.defaultDialect;
                }
                case 9: {
                    switch (minorVersion) {
                        case 0: {
                            return DialectHolder.postgreSQL90;
                        }
                        case 1: {
                            return DialectHolder.postgreSQL91;
                        }
                        case 2: {
                            return DialectHolder.postgreSQL92;
                        }
                        case 3: {
                            return DialectHolder.postgreSQL93;
                        }
                        case 4: {
                            return DialectHolder.postgreSQL94;
                        }
                        case 5: {
                            return DialectHolder.postgreSQL95;
                        }
                        case 6: {
                            return DialectHolder.postgreSQL96;
                        }
                    }
                    return DialectHolder.postgreSQL90;
                }
                case 10: {
                    switch (minorVersion) {
                        default: 
                    }
                    return DialectHolder.postgreSQL100;
                }
                case 11: {
                    switch (minorVersion) {
                        default: 
                    }
                    return DialectHolder.postgreSQL110;
                }
                case 12: {
                    switch (minorVersion) {
                        default: 
                    }
                    return DialectHolder.postgreSQL120;
                }
            }
            return DialectHolder.defaultDialect;
        }

        public static class DialectHolder {
            static final Dialect postgreSQL120 = DialectUtils.getInstance(Postgres120.class);
            static final Dialect postgreSQL110 = DialectUtils.getInstance(Postgres110.class, () -> postgreSQL120);
            static final Dialect postgreSQL100 = DialectUtils.getInstance(Postgres100.class, () -> postgreSQL110);
            static final Dialect postgreSQL96 = DialectUtils.getInstance(Postgres96.class, () -> postgreSQL100);
            static final Dialect postgreSQL95 = DialectUtils.getInstance(Postgres95.class, () -> postgreSQL96);
            static final Dialect postgreSQL94 = DialectUtils.getInstance(Postgres94.class, () -> postgreSQL95);
            static final Dialect postgreSQL93 = DialectUtils.getInstance(Postgres93.class, () -> postgreSQL94);
            static final Dialect postgreSQL92 = DialectUtils.getInstance(Postgres92.class, () -> postgreSQL93);
            static final Dialect postgreSQL91 = DialectUtils.getInstance(Postgres91.class, () -> postgreSQL92);
            static final Dialect postgreSQL90 = DialectUtils.getInstance(Postgres90.class, () -> postgreSQL91);
            static final Dialect postgreSQL84 = DialectUtils.getInstance(Postgres84.class, () -> postgreSQL90);
            static final Dialect postgreSQL83 = DialectUtils.getInstance(Postgres83.class, () -> postgreSQL84);
            static final Dialect postgreSQL82 = DialectUtils.getInstance(Postgres83.class, () -> postgreSQL83);
            static final Dialect defaultDialect = DialectUtils.getInstance(Postgres.class, () -> postgreSQL82);
        }
    }
}

