/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ReaderUtils;
import com.sqlapp.data.db.metadata.SqlNodeCache;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.JdbcQueryHandler;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgresUtils
extends ReaderUtils {
    private static Map<String, WeakReference<NamedArgument>> TYPE_CACHE = new HashMap<String, WeakReference<NamedArgument>>();
    private static final Pattern RELOPTION_PATTERN = Pattern.compile("\\s*\\{(.*)\\}\\s*", 2);

    public static void setColumnMetadata(ResultSet rs, Dialect dialect, AbstractColumn<?> column) throws SQLException {
        column.setName(rs.getString("attname"));
        column.setSchemaName(rs.getString("nspname"));
        String productDataType = rs.getString("typname");
        int arrayDimension = rs.getInt("attndims");
        String intervalTypeName = rs.getString("interval_type_name");
        if (arrayDimension > 0) {
            productDataType = CommonUtils.ltrim((String)productDataType, (char)'_');
        }
        productDataType = CommonUtils.notEmpty((String)intervalTypeName, (String)productDataType);
        Long maxLength = PostgresUtils.getLong((ResultSet)rs, (String)"max_length");
        Long numericPrecision = PostgresUtils.getLong((ResultSet)rs, (String)"numeric_precision");
        Integer numericScale = PostgresUtils.getInteger((ResultSet)rs, (String)"numeric_scale");
        Integer datetimeScale = PostgresUtils.getInteger((ResultSet)rs, (String)"datetime_scale");
        Integer intervalScale = PostgresUtils.getInteger((ResultSet)rs, (String)"interval_scale");
        String sequenceName = rs.getString("sequence_name");
        boolean nullable = !rs.getBoolean("attnotnull");
        boolean autoIncrement = !CommonUtils.isEmpty((CharSequence)sequenceName);
        column.setNullable(nullable);
        column.setIdentity(autoIncrement);
        dialect.setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{maxLength, numericPrecision}), CommonUtils.notZero((Integer[])new Integer[]{numericScale, datetimeScale, intervalScale}), column);
        if (!CommonUtils.isEmpty((CharSequence)sequenceName)) {
            String[] names = sequenceName.split("[.]");
            Sequence sequence = new Sequence(names[names.length - 1]);
            if (names.length > 1) {
                sequence.setSchemaName(names[names.length - 2]);
            }
            column.setSequence(sequence);
        }
        column.setArrayDimension(arrayDimension);
        column.setDefaultValue(rs.getString("adsrc"));
        column.setRemarks(rs.getString("remarks"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedArgument getTypeInfoById(Connection connection, final Dialect dialect, final String typeId) {
        WeakReference<NamedArgument> ref = TYPE_CACHE.get(typeId);
        NamedArgument arg = null;
        if (ref != null) {
            arg = (NamedArgument)ref.get();
            if (arg != null) {
                return arg;
            }
            Map<String, WeakReference<NamedArgument>> map = TYPE_CACHE;
            synchronized (map) {
                Set keySet = CommonUtils.set();
                for (Map.Entry<String, WeakReference<NamedArgument>> entry : TYPE_CACHE.entrySet()) {
                    if (entry.getValue() != null && entry.getValue().get() != null) continue;
                    keySet.add(entry.getKey());
                }
                for (String key : keySet) {
                    TYPE_CACHE.remove(key);
                }
            }
        }
        SqlNode node = PostgresUtils.getSqlNodeCache().getString("typeById.sql");
        ParametersContext context = new ParametersContext();
        context.put("typeId", (Object)Integer.valueOf(typeId));
        final NamedArgument obj = new NamedArgument();
        obj.setDialect(dialect);
        PostgresUtils.execute(connection, node, context, new ResultSetNextHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String typeName = rs.getString("type_name");
                obj.setDialect(dialect);
                obj.setDataTypeName(typeName);
                Map map = TYPE_CACHE;
                synchronized (map) {
                    TYPE_CACHE.put(typeId, new WeakReference<NamedArgument>(obj));
                }
            }
        });
        if (obj.getDataTypeName() == null && obj.getDataType() == null) {
            throw new RuntimeException("typeId=" + typeId);
        }
        return obj;
    }

    public static List<NamedArgument> getTypeInfoById(Connection connection, Dialect dialect, String ... typeIds) {
        List result = CommonUtils.list();
        for (String typeId : typeIds) {
            NamedArgument routineArgument = PostgresUtils.getTypeInfoById(connection, dialect, typeId);
            result.add(routineArgument);
        }
        return result;
    }

    public static List<NamedArgument> getTypeInfoById(Connection connection, Dialect dialect, String[] typeIds, String[] argNames, String[] argModes) {
        List result = CommonUtils.list();
        for (int i = 0; i < typeIds.length; ++i) {
            NamedArgument routineArgument = PostgresUtils.getTypeInfoById(connection, dialect, typeIds[i]);
            if (!CommonUtils.isEmpty((Object)argModes) && argModes.length > i) {
                String mode = argModes[i];
                if ("o".equalsIgnoreCase(mode)) {
                    routineArgument.setDirection(ParameterDirection.Output);
                } else if ("io".equalsIgnoreCase(mode)) {
                    routineArgument.setDirection(ParameterDirection.Inout);
                }
            }
            if (!CommonUtils.isEmpty((Object)argNames) && argNames.length > i) {
                String name = CommonUtils.unwrap((String)argNames[i], (String)"\"");
                routineArgument.setName(name);
            }
            result.add(routineArgument);
        }
        return result;
    }

    public static List<NamedArgument> getTypeInfoById(Connection connection, Dialect dialect, String[] typeIds, String[] argNames, String[] argModes, String[] argDefaults) {
        List result = CommonUtils.list();
        for (int i = 0; i < typeIds.length; ++i) {
            NamedArgument routineArgument = PostgresUtils.getTypeInfoById(connection, dialect, typeIds[i]);
            if (!CommonUtils.isEmpty((Object)argModes) && argModes.length > i) {
                String mode = argModes[i];
                if ("o".equalsIgnoreCase(mode)) {
                    routineArgument.setDirection(ParameterDirection.Output);
                } else if ("io".equalsIgnoreCase(mode)) {
                    routineArgument.setDirection(ParameterDirection.Inout);
                }
            }
            if (!CommonUtils.isEmpty((Object)argDefaults) && argDefaults.length > i) {
                routineArgument.setDefaultValue(argDefaults[i]);
            }
            if (!CommonUtils.isEmpty((Object)argNames) && argNames.length > i) {
                String name = argNames[i];
                routineArgument.setName(name);
            }
            result.add(routineArgument);
        }
        return result;
    }

    protected static JdbcQueryHandler execute(Connection connection, SqlNode node, ParametersContext context, ResultSetNextHandler handler) {
        JdbcQueryHandler jdbcQueryHandler = new JdbcQueryHandler(node, handler);
        return jdbcQueryHandler.execute(connection, context);
    }

    protected static SqlNodeCache getSqlNodeCache() {
        return SqlNodeCache.getInstance(PostgresUtils.class);
    }

    public static Map<String, String> parseRelOption(String value) {
        if (value == null || value.length() == 0) {
            return Collections.emptyMap();
        }
        Map map = CommonUtils.map();
        Matcher matcher = RELOPTION_PATTERN.matcher(value);
        if (matcher.matches()) {
            String[] args;
            value = matcher.group(1);
            for (String arg : args = value.split("\\s*(,;)\\s*")) {
                String[] splits = arg.split("\\s*=\\s*");
                if (splits.length != 2) {
                    throw new IllegalArgumentException("value=" + value);
                }
                map.put(splits[0], splits[1]);
            }
        }
        return Collections.emptyMap();
    }
}

