/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresUtils;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.OnNullCall;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.SqlSecurity;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresFunctionReader
extends FunctionReader {
    protected PostgresFunctionReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Function function = PostgresFunctionReader.this.createFunction(rs);
                result.add(function);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("functions.sql");
        return node;
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        String provolatile;
        Boolean proisstrict;
        Boolean prosecdef;
        Function obj = new Function(this.getString((ResultSet)rs, "function_name"));
        obj.setDialect(this.getDialect());
        obj.setSchemaName(this.getString((ResultSet)rs, "function_schema"));
        obj.setLanguage(this.getString((ResultSet)rs, "lanname"));
        if (this.getReaderOptions().isReadStatement()) {
            obj.setStatement(this.getString((ResultSet)rs, "prosrc"));
        }
        if ((prosecdef = this.getBoolean((ResultSet)rs, "prosecdef")) != null) {
            if (prosecdef.booleanValue()) {
                obj.setSqlSecurity(SqlSecurity.Definer);
            } else {
                obj.setSqlSecurity(SqlSecurity.Invoker);
            }
        }
        if ((proisstrict = this.getBoolean((ResultSet)rs, "proisstrict")) != null) {
            if (proisstrict.booleanValue()) {
                obj.setOnNullCall(OnNullCall.ReturnsNullOnNullInput);
            } else {
                obj.setOnNullCall(OnNullCall.CalledOnNullInput);
            }
        }
        if ("i".equalsIgnoreCase(provolatile = this.getString((ResultSet)rs, "provolatile"))) {
            obj.setDeterministic(Boolean.valueOf(true));
        } else if ("v".equalsIgnoreCase(provolatile)) {
            obj.setDeterministic(Boolean.valueOf(false));
        } else if ("s".equalsIgnoreCase(provolatile)) {
            obj.setStable(Boolean.valueOf(true));
        }
        String retTypeId = this.getString((ResultSet)rs, "prorettype");
        NamedArgument routineArgument = PostgresUtils.getTypeInfoById(rs.getStatement().getConnection(), this.getDialect(), retTypeId);
        obj.getReturning().setDataTypeName(routineArgument.getDataTypeName());
        obj.getReturning().setDataType(routineArgument.getDataType());
        obj.getReturning().setLength((Number)routineArgument.getLength());
        obj.getReturning().setScale((Number)routineArgument.getScale());
        int argNo = rs.getInt("pronargs");
        if (argNo > 0) {
            this.setArguments(rs, obj);
        }
        return obj;
    }

    protected void setArguments(ExResultSet rs, Function obj) throws SQLException {
        String allArgTypes = CommonUtils.unwrap((String)rs.getString("proargtypes"), (String)"{", (String)"}");
        String allArgModes = CommonUtils.unwrap((String)rs.getString("proargmodes"), (String)"{", (String)"}");
        String allArgNames = CommonUtils.unwrap((String)rs.getString("proargnames"), (String)"{", (String)"}");
        String[] argArray = CommonUtils.split((String)allArgTypes, (String)"[, ]");
        String[] argModeArray = CommonUtils.split((String)allArgModes, (String)"[, ]");
        String[] argNameArray = CommonUtils.split((String)allArgNames, (String)"[, ]");
        if (allArgTypes != null) {
            SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
            List<NamedArgument> arguments = PostgresUtils.getTypeInfoById(rs.getStatement().getConnection(), this.getDialect(), argArray, argNameArray, argModeArray);
            for (NamedArgument argument : arguments) {
                builder.add((Object)argument.getDataTypeName());
            }
            obj.setSpecificName(obj.getName() + "(" + builder.toString() + ")");
            obj.getArguments().addAll(arguments);
        }
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return null;
    }
}

