/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecoder;
import org.postgresql.util.PGobject;

public class PostgresGeometryJdbcTypeHandler
implements JdbcTypeHandler {
    public Object getObject(ResultSet rs, int columnIndex) throws SQLException {
        Object obj = rs.getObject(columnIndex);
        return this.convertInternal(obj);
    }

    private Object convertInternal(Object obj) {
        if (obj instanceof PGobject) {
            String pgValue = ((PGobject)obj).getValue();
            if (pgValue.charAt(0) == 'S') {
                WktDecoder decoder = Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1);
                return decoder.decode(pgValue);
            }
            ByteBuffer buffer = ByteBuffer.from((String)pgValue);
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            return decoder.decode(buffer);
        }
        byte[] bytes = (byte[])Converters.getDefault().convertObject(obj, byte[].class);
        WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        return decoder.decode(ByteBuffer.from((byte[])bytes));
    }

    public Object getObject(ResultSet rs, String columnLabel) throws SQLException {
        Object obj = rs.getObject(columnLabel);
        return this.convertInternal(obj);
    }

    public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
        Geometry geometry = (Geometry)Converters.getDefault().convertObject(x, Geometry.class);
        WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        byte[] bytes = encoder.encode(geometry, ByteOrder.NDR).toByteArray();
        stmt.setBytes(parameterIndex, bytes);
    }
}

