/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.Postgres83FunctionFamilyReader;
import com.sqlapp.data.db.dialect.postgres.metadata.Postgres83OperatorFamilyReader;
import com.sqlapp.data.db.metadata.FunctionFamilyReader;
import com.sqlapp.data.db.metadata.OperatorClassReader;
import com.sqlapp.data.db.metadata.OperatorFamilyReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.OperatorClass;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class Postgres83OperatorClassReader
extends OperatorClassReader {
    protected Postgres83OperatorClassReader(Dialect dialect) {
        super(dialect);
    }

    protected List<OperatorClass> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                OperatorClass obj = Postgres83OperatorClassReader.this.createOperatorClass(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("operatorClasses83.sql");
    }

    protected OperatorClass createOperatorClass(ExResultSet rs) throws SQLException {
        OperatorClass obj = new OperatorClass(this.getString((ResultSet)rs, "operator_class_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setDialect(this.getDialect());
        obj.setIndexType(this.getString((ResultSet)rs, "index_type"));
        obj.setDefault(rs.getBoolean("operator_default"));
        obj.setDataTypeName(this.getString((ResultSet)rs, "data_type"));
        return obj;
    }

    protected OperatorFamilyReader newOperatorFamilyReader() {
        return new Postgres83OperatorFamilyReader(this.getDialect());
    }

    protected FunctionFamilyReader newFunctionFamilyReader() {
        return new Postgres83FunctionFamilyReader(this.getDialect());
    }
}

