/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresEnumReader
extends DomainReader {
    protected PostgresEnumReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Domain> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String schemaname = this.getString(rs, "nspname");
                String typname = this.getString(rs, "typname");
                String enumlabel = this.getString(rs, "enumlabel");
                Domain obj = null;
                for (Domain val : result) {
                    if (!CommonUtils.eqIgnoreCase((String)val.getSchemaName(), (String)schemaname) || !CommonUtils.eq((Object)val.getName(), (Object)typname)) continue;
                    obj = val;
                    break;
                }
                if (obj == null) {
                    obj = new Domain(typname);
                    obj.setSchemaName(schemaname);
                    obj.setDataTypeName(typname);
                    obj.setDataType(DataType.ENUM);
                    result.add(obj);
                }
                obj.getValues().add(enumlabel);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("enums.sql");
    }
}

