/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.RoleReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Role;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresRoleReader
extends RoleReader {
    protected PostgresRoleReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Role> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Role obj = PostgresRoleReader.this.createRole(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("roles.sql");
    }

    protected Role createRole(ExResultSet rs) throws SQLException {
        String name = this.getString((ResultSet)rs, "rolname");
        Role obj = new Role(name);
        obj.setId(this.getString((ResultSet)rs, "oid"));
        this.setSpecifics((ResultSet)rs, "rolsuper", "superuser", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolinherit", "inherit", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolcreaterole", "createrole", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolcreatedb", "createdb", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolcanlogin", "login", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolconnlimit", "connection limit", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolvaliduntil", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "rolconfig", "config", (SpecificsProperty)obj);
        return obj;
    }
}

