/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresTypeColumnReader;
import com.sqlapp.data.db.metadata.TypeColumnReader;
import com.sqlapp.data.db.metadata.TypeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresTypeReader
extends TypeReader {
    protected PostgresTypeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Type> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Type obj = PostgresTypeReader.this.createType(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected TypeColumnReader newColumnFactory() {
        return new PostgresTypeColumnReader(this.getDialect());
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("types.sql");
    }

    protected Type createType(ExResultSet rs) throws SQLException {
        Type obj = new Type(this.getString((ResultSet)rs, "type_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "type_schema"));
        obj.setDefinition(CommonUtils.splitLine((String)this.getString((ResultSet)rs, "definition")));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        return obj;
    }
}

