/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractInsertRowFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.List;

public class PostgresInsertRowFactory
extends AbstractInsertRowFactory<PostgresSqlBuilder> {
    protected List<SqlOperation> getOperations(Table table, Collection<Row> rows) {
        List sqlList = CommonUtils.list();
        if (rows == null) {
            return sqlList;
        }
        Row firstRow = (Row)CommonUtils.first(rows);
        PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
        ((PostgresSqlBuilder)builder.insert()).into();
        ((PostgresSqlBuilder)builder.space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
        ((PostgresSqlBuilder)builder.lineBreak())._add("(");
        builder.appendIndent(1);
        boolean[] first = new boolean[]{true};
        for (Column column : table.getColumns()) {
            String def = this.getValueDefinitionForInsert(firstRow, column);
            builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                ((PostgresSqlBuilder)builder.comma(!first[0])).name(column);
                first[0] = false;
            });
        }
        builder.appendIndent(-1);
        ((PostgresSqlBuilder)builder.space())._add(")");
        builder.lineBreak();
        builder.values();
        for (Row row : rows) {
            first[0] = true;
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).comma(row != firstRow)).space(row != firstRow))._add("(");
            builder.appendIndent(1);
            for (Column column : row.getTable().getColumns()) {
                String def = this.getValueDefinitionForInsert(row, column);
                builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                    ((PostgresSqlBuilder)builder.comma(!first[0]))._add(def);
                    first[0] = false;
                });
            }
            builder.appendIndent(-1);
            builder._add(")");
        }
        this.addSql(sqlList, builder, SqlType.INSERT_ROW, CommonUtils.list(rows));
        return sqlList;
    }
}

