/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlite.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.dialect.util.SqlTokenizer;
import com.sqlapp.data.db.dialect.util.StringHolder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqliteSqlSplitter
extends SqlSplitter {
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\s*CREATE\\s+(TEMP|TEMPORARY)?\\s*TRIGGER\\s*.*?\\s+BEGIN\\s*\\n(.*)", 42);
    private static final Pattern END_PATTERN = Pattern.compile("\\s*END\\s*;?", 42);

    public SqliteSqlSplitter(Dialect dialect) {
        super(dialect);
    }

    protected SqlTokenizer createSqlTokenizer(String input) {
        return new SqlTokenizer(input){

            protected boolean isStartStatement(String text, StringHolder stringHolder) {
                Matcher matcher = stringHolder.substringMatcher(FUNCTION_PATTERN);
                if (matcher.matches()) {
                    int index = stringHolder.indexOf("BEGIN");
                    if (index >= 0) {
                        int ePos = stringHolder.searchLineOf(END_PATTERN, index + 6);
                        if (ePos >= 0) {
                            int pos = stringHolder.indexOf(this.getCurrentDelimiter(), ePos + 3);
                            this.setPosition(pos);
                            return true;
                        }
                        stringHolder.throwInvalidTextException("[END] of TRIGGER not found.[" + stringHolder.substringAt() + "]");
                    } else {
                        stringHolder.throwInvalidTextException("[AS] of Function not found.[" + stringHolder.substringAt() + "]");
                    }
                }
                return false;
            }
        };
    }
}

