/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2000IndexReader
extends IndexReader {
    public static final String PAD_INDEX = "PAD_INDEX";
    public static final String ALLOW_ROW_LOCKS = "ALLOW_ROW_LOCKS";
    public static final String ALLOW_PAGE_LOCKS = "ALLOW_PAGE_LOCKS";
    public static final String AUTO_CREATE_STATISTICS = "auto_create_statistics";
    public static final String FILE_GROUP_NAME = "index_file_group_name";

    public SqlServer2000IndexReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Index> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name;
                String schema_name;
                String catalog_name = this.getString(rs, "catalog_name");
                Index index = (Index)map.get((Object)catalog_name, (Object)(schema_name = this.getString(rs, "schema_name")), (Object)(name = this.getString(rs, "index_name")));
                if (index == null) {
                    index = SqlServer2000IndexReader.this.createIndex(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)name, (Object)index);
                }
                String columnName = this.getString(rs, "column_name");
                if (rs.getInt("is_descending") == 1) {
                    index.getColumns().add(new Column(columnName), Order.Desc);
                } else {
                    index.getColumns().add(new Column(columnName), Order.Asc);
                }
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("indexes2000.sql");
    }

    protected Index createIndex(ExResultSet rs) throws SQLException {
        Index index = new Index(this.getString((ResultSet)rs, "index_name"));
        index.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        index.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        index.setTableName(this.getString((ResultSet)rs, "table_name"));
        index.setIndexType(SqlServerUtils.getIndexType(rs.getInt("type")));
        boolean uniqueness = rs.getInt("is_unique") == 1;
        index.setUnique(uniqueness);
        this.setSpecifics(rs, "fill_factor", (SpecificsProperty)index);
        this.setSpecifics(rs, PAD_INDEX, (SpecificsProperty)index);
        this.setSpecifics(rs, ALLOW_ROW_LOCKS, (SpecificsProperty)index);
        this.setSpecifics(rs, ALLOW_PAGE_LOCKS, (SpecificsProperty)index);
        this.setSpecifics(rs, AUTO_CREATE_STATISTICS, (SpecificsProperty)index);
        this.setSpecifics(rs, FILE_GROUP_NAME, (SpecificsProperty)index);
        return index;
    }
}

