/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerIndexOptions;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2000UniqueConstraintReader
extends UniqueConstraintReader {
    protected SqlServer2000UniqueConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<UniqueConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name;
                String schema_name;
                String catalog_name = this.getString(rs, "catalog_name");
                UniqueConstraint obj = (UniqueConstraint)map.get((Object)catalog_name, (Object)(schema_name = this.getString(rs, "schema_name")), (Object)(name = this.getString(rs, "index_name")));
                if (obj == null) {
                    obj = SqlServer2000UniqueConstraintReader.this.createUniqueConstraint(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)name, (Object)obj);
                }
                String columnName = this.getString(rs, "column_name");
                if (rs.getInt("is_descending_key") == 1) {
                    obj.getColumns().add(new Column(columnName), Order.Desc);
                } else {
                    obj.getColumns().add(new Column(columnName), Order.Asc);
                }
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("uniqueConstraints2000.sql");
    }

    protected UniqueConstraint createUniqueConstraint(ExResultSet rs) throws SQLException {
        UniqueConstraint obj = new UniqueConstraint(this.getString((ResultSet)rs, "index_name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setTableName(this.getString((ResultSet)rs, "table_name"));
        obj.setPrimaryKey(rs.getInt("is_primary_key") == 1);
        obj.setIndexType(SqlServerUtils.getIndexType(rs.getInt("type")));
        obj.setEnable(rs.getInt("is_disabled") != 1);
        SqlServerIndexOptions.setAllUniqueConstraint(rs, obj);
        this.setSpecifics(rs, "FILE_GROUP_NAME", (SpecificsProperty)obj);
        return obj;
    }
}

