/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000CheckConstraintReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000ColumnReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000ForeignKeyConstraintReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000IndexReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000UniqueConstraintReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2000TableReader
extends TableReader {
    protected SqlServer2000TableReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = SqlServer2000TableReader.this.createTable(rs);
                result.add(table);
            }
        });
        for (Table table : result) {
            this.setTableComment(connection, table);
        }
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables2000.sql");
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        Table table = super.createTable(this.getString((ResultSet)rs, "table_name"));
        table.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        table.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        table.setCreatedAt(rs.getTimestamp("create_date"));
        table.setId("" + rs.getInt("table_id"));
        table.setTableSpaceName(this.getString((ResultSet)rs, "file_group_name"));
        table.setLobTableSpaceName(this.getString((ResultSet)rs, "lob_file_group_name"));
        table.setRemarks(this.getString((ResultSet)rs, "remarks"));
        this.setSpecifics(rs, "text_in_row_limit", (SpecificsProperty)table);
        return table;
    }

    protected void setTableComment(Connection connection, final Table table) {
        SqlNode node = this.getSqlNodeCache().getString("tableComments2000.sql");
        ParametersContext context = this.defaultParametersContext(connection);
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String remarks = this.getString(rs, "value");
                table.setRemarks(remarks);
            }
        });
    }

    protected ColumnReader newColumnReader() {
        return new SqlServer2000ColumnReader(this.getDialect());
    }

    protected IndexReader newIndexReader() {
        return new SqlServer2000IndexReader(this.getDialect());
    }

    protected UniqueConstraintReader newUniqueConstraintReader() {
        return new SqlServer2000UniqueConstraintReader(this.getDialect());
    }

    protected CheckConstraintReader newCheckConstraintReader() {
        return new SqlServer2000CheckConstraintReader(this.getDialect());
    }

    protected ForeignKeyConstraintReader newForeignKeyConstraintReader() {
        return new SqlServer2000ForeignKeyConstraintReader(this.getDialect());
    }

    protected ExcludeConstraintReader newExcludeConstraintReader() {
        return null;
    }
}

