/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005DomainReader
extends DomainReader {
    protected SqlServer2005DomainReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Domain> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        final List result = CommonUtils.list();
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Domain obj = SqlServer2005DomainReader.this.createDomain(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("domains2005.sql");
    }

    protected Domain createDomain(ExResultSet rs) throws SQLException {
        String name = this.getString((ResultSet)rs, "domain_name");
        Domain obj = new Domain(name);
        String productDataType = this.getString((ResultSet)rs, "base_type_name");
        Long byteLength = this.getLong((ResultSet)rs, "max_length");
        Long max_length = SqlServerUtils.getMaxLength(productDataType, byteLength);
        Long prec = this.getLong((ResultSet)rs, "precision");
        Integer scale = this.getInteger((ResultSet)rs, "scale");
        obj.setNullable(rs.getBoolean("is_nullable"));
        this.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{max_length, prec}), scale, (DataTypeLengthProperties)obj);
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setCollation(this.getString((ResultSet)rs, "collation_name"));
        this.setSpecifics(rs, "rule_name", (SpecificsProperty)obj);
        this.setSpecifics(rs, "assembly_name", (SpecificsProperty)obj);
        this.setSpecifics(rs, "assembly_class", (SpecificsProperty)obj);
        return obj;
    }
}

