/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2000;
import com.sqlapp.data.db.dialect.sqlserver.resolver.SqlServerDialectResolver;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EnumUtils;
import com.sqlapp.util.OnOffType;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SqlServerIndexOptions {
    PAD_INDEX{

        public OnOffType getDefaultValue() {
            return OnOffType.OFF;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    FILLFACTOR{

        @Override
        public void setIndex(Index index, Object value) {
            Integer val = (Integer)Converters.getDefault().convertObject(value, Integer.class);
            if (val == null) {
                index.getSpecifics().remove((Object)this.getColumnKey());
                index.getSpecifics().remove((Object)this.toString());
            } else if (val >= 0 && val <= 100) {
                index.getSpecifics().remove((Object)this.getColumnKey());
                index.getSpecifics().remove((Object)this.toString());
                if (val != 0) {
                    index.getSpecifics().put(this.toString(), (Object)val);
                }
            }
        }

        @Override
        public String getColumnKey() {
            return "FILL_FACTOR";
        }
    }
    ,
    SORT_IN_TEMPDB{

        public OnOffType getDefaultValue() {
            return OnOffType.OFF;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    IGNORE_DUP_KEY{

        public OnOffType getDefaultValue() {
            return OnOffType.OFF;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    STATISTICS_NORECOMPUTE{

        public OnOffType getDefaultValue() {
            return OnOffType.OFF;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    STATISTICS_INCREMENTAL{

        public OnOffType getDefaultValue() {
            return OnOffType.OFF;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }

        @Override
        public Supplier<Dialect> getSupportVersion() {
            return () -> SqlServerDialectResolver.getInstance().getDialect(12, 0);
        }
    }
    ,
    ALLOW_ROW_LOCKS{

        public OnOffType getDefaultValue() {
            return OnOffType.ON;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    ALLOW_PAGE_LOCKS{

        public OnOffType getDefaultValue() {
            return OnOffType.ON;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    OPTIMIZE_FOR_SEQUENTIAL_KEY{

        public OnOffType getDefaultValue() {
            return OnOffType.OFF;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }

        @Override
        public Supplier<Dialect> getSupportVersion() {
            return () -> SqlServerDialectResolver.getInstance().getDialect(15, 0);
        }
    }
    ,
    COMPRESSION_DELAY{

        @Override
        public void setTable(ExResultSet rs, Table table) throws SQLException {
            if (!rs.contains(this.toString())) {
                return;
            }
            int val = rs.getInt(this.toString());
            if (val > 0) {
                table.getSpecifics().put(this.toString(), (Object)val);
            } else {
                table.getSpecifics().remove((Object)this.toString());
            }
        }
    }
    ,
    DATA_COMPRESSION{

        @Override
        public void setTable(ExResultSet rs, Table table) throws SQLException {
            if (!rs.contains(this.toString())) {
                return;
            }
            String val = rs.getNString(this.toString());
            if ("NONE".equalsIgnoreCase(val)) {
                table.setCompression(false);
                table.setCompressionType(null);
            } else {
                table.setCompression(true);
                table.setCompressionType(val.toUpperCase());
            }
        }
    };


    public Class<?> getValueClass() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public void setIndex(Index index, Object value) {
    }

    public void setTable(Table table, String value) {
    }

    public void setTable(ExResultSet rs, Table table) throws SQLException {
        this.setParams(rs, val -> {
            if (val != null) {
                this.setTable(table, val.toString());
            } else {
                this.setTable(table, null);
            }
        });
    }

    public void setIndex(ExResultSet rs, Index index) throws SQLException {
        this.setParams(rs, val -> {
            if (val != null) {
                this.setIndex(index, val);
            } else {
                this.setIndex(index, null);
            }
        });
    }

    public static void setAllIndex(ExResultSet rs, Index index) throws SQLException {
        for (SqlServerIndexOptions enm : SqlServerIndexOptions.values()) {
            enm.setIndex(rs, index);
        }
    }

    public String getColumnKey() {
        return this.toString();
    }

    public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uk) throws SQLException {
    }

    public static void setAllUniqueConstraint(ExResultSet rs, UniqueConstraint uk) throws SQLException {
        for (SqlServerIndexOptions enm : SqlServerIndexOptions.values()) {
            enm.setUniqueConstraint(rs, uk);
        }
    }

    protected void setIndexOnOffParams(Index index, Object value) {
        OnOffType onOffType = OnOffType.parse((Object)value);
        index.getSpecifics().put(this.toString(), (Object)onOffType);
    }

    protected void setParams(ExResultSet rs, Consumer<Object> cons) throws SQLException {
        if (!rs.contains(this.getColumnKey())) {
            return;
        }
        Object val = rs.getObject(this.getColumnKey());
        cons.accept(val);
    }

    public boolean supports(SqlServer2000 dialect) {
        Dialect target = this.getSupportVersion().get();
        return dialect.compareTo(target) >= 0;
    }

    public Supplier<Dialect> getSupportVersion() {
        return () -> SqlServerDialectResolver.getInstance().getDialect(10, 0);
    }

    protected void setOnOffParams(ExResultSet rs, SpecificsProperty<?> obj) throws SQLException {
        if (!rs.contains(this.toString())) {
            return;
        }
        boolean bool = rs.getBoolean(this.getColumnKey());
        OnOffType onOffType = OnOffType.parse((Object)bool);
        obj.getSpecifics().put(this.toString(), (Object)onOffType);
    }

    public static SqlServerIndexOptions parse(Object obj) {
        SqlServerIndexOptions enm = (SqlServerIndexOptions)EnumUtils.parse(SqlServerIndexOptions.class, (Object)obj);
        if (enm != null) {
            return enm;
        }
        if (obj instanceof String) {
            String val = ((String)String.class.cast(obj)).toUpperCase().replace("_", "");
            for (SqlServerIndexOptions e : SqlServerIndexOptions.values()) {
                if (!CommonUtils.eq((Object)val, (Object)e.toString().replace("_", ""))) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isOnOff() {
        return this.getValueClass() == OnOffType.class;
    }
}

