/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.db.datatype.util;

import com.sqlapp.data.db.datatype.util.ColumnTypeMatcher;
import com.sqlapp.data.db.datatype.util.ColumnTypeMatcherWrapper;
import com.sqlapp.data.db.datatype.util.TypeInformation;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlServerNumberColumnTypeMatcher
implements ColumnTypeMatcher,
ColumnTypeMatcherWrapper {
    private static final Pattern PATTERN = Pattern.compile("(?<dataTypeName>.*?)\\S+IDENTITY");
    private ColumnTypeMatcher internalMatcher;

    public SqlServerNumberColumnTypeMatcher(ColumnTypeMatcher internalMatcher) {
        this.internalMatcher = internalMatcher;
    }

    public Optional<TypeInformation> match(String productDataType) {
        Matcher matcher = PATTERN.matcher(productDataType);
        String typeName = productDataType;
        if (matcher.matches()) {
            typeName = matcher.group("dataTypeName");
            Optional op = this.internalMatcher.match(typeName);
            if (op.isPresent()) {
                ((TypeInformation)op.get()).setIdentity(true);
            }
            return op;
        }
        Optional op = this.internalMatcher.match(typeName);
        return op;
    }

    public ColumnTypeMatcher getInternal() {
        return this.internalMatcher;
    }
}

