/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.PartitionSchemeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.PartitionScheme;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005PartitionSchemeReader
extends PartitionSchemeReader {
    protected SqlServer2005PartitionSchemeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<PartitionScheme> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final DoubleKeyMap map = CommonUtils.doubleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name;
                String catalog_name = this.getString(rs, "catalog_name");
                PartitionScheme obj = (PartitionScheme)map.get((Object)catalog_name, (Object)(name = this.getString(rs, PARTITION_SHCEME_NAME)));
                if (obj == null) {
                    obj = SqlServer2005PartitionSchemeReader.this.createPartitionScheme(rs);
                    map.put((Object)catalog_name, (Object)name, (Object)obj);
                }
                obj.getTableSpaces().add((AbstractBaseDbObject)new TableSpace(this.getString(rs, "file_group_name")));
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("partitionSchemes2005.sql");
    }

    protected PartitionScheme createPartitionScheme(ExResultSet rs) throws SQLException {
        String catalog_name = this.getString((ResultSet)rs, "catalog_name");
        String name = this.getString((ResultSet)rs, PARTITION_SHCEME_NAME);
        PartitionScheme obj = new PartitionScheme(name);
        obj.setCatalogName(catalog_name);
        obj.setDefault(rs.getBoolean("is_default"));
        obj.setId("" + rs.getInt("data_space_id"));
        obj.setPartitionFunctionName(this.getString((ResultSet)rs, "function_name"));
        return obj;
    }
}

