/**
 * Copyright (C) 2007-2017 Tatsuo Satoh <multisqllib@gmail.com>
 *
 * This file is part of sqlapp-core-sqlserver.
 *
 * sqlapp-core-sqlserver is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * sqlapp-core-sqlserver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with sqlapp-core-sqlserver.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sqlapp.data.db.dialect.sqlserver.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.NamedArgumentCollection;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;

public class SqlServerSqlBuilder extends
		AbstractSqlBuilder<SqlServerSqlBuilder> {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -3976029895381266407L;

	public SqlServerSqlBuilder(Dialect dialect) {
		super(dialect);
	}

	/**
	 * IDENTITY句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder identity() {
		appendElement("IDENTITY");
		return instance();
	}
	
	/**
	 * INCLUDE句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder include() {
		appendElement("INCLUDE");
		return instance();
	}

	/**
	 * IDENTITY_INSERT句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder identityInsert() {
		appendElement("IDENTITY_INSERT");
		return instance();
	}

	/**
	 * PERMISSION_SET句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder permissionSet() {
		appendElement("PERMISSION_SET");
		return instance();
	}

	/**
	 * AGGREGATE句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder aggregate() {
		appendElement("AGGREGATE");
		return instance();
	}

	/**
	 * READONLY句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder readonly() {
		appendElement("READONLY");
		return instance();
	}

	/**
	 * SCHEME句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder scheme() {
		appendElement("SCHEME");
		return instance();
	}

	/**
	 * RANGE句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder range() {
		appendElement("RANGE");
		return instance();
	}

	/**
	 * ENABLE句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder enable() {
		appendElement("ENABLE");
		return instance();
	}

	/**
	 * OWNER句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder owner() {
		appendElement("OWNER");
		return instance();
	}
	
	/**
	 * CALLER句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder caller() {
		appendElement("CALLER");
		return instance();
	}
	
	
	/**
	 * DISABLE句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder disable() {
		appendElement("DISABLE");
		return instance();
	}

	/**
	 * CHANGE_TRACKING句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder changeTracking() {
		appendElement("CHANGE_TRACKING");
		return instance();
	}

	/**
	 * TABLOCK句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder tablock() {
		appendElement("TABLOCK");
		return instance();
	}

	/**
	 * HOLDLOCK句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder holdlock() {
		appendElement("HOLDLOCK");
		return instance();
	}
	
	/**
	 * UPDLOCK句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder updlock() {
		appendElement("UPDLOCK");
		return instance();
	}

	/**
	 * FILETABLE句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder filetable() {
		appendElement("FILETABLE");
		return instance();
	}

	/**
	 * FILETABLE_DIRECTORY句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder filetableDirectory() {
		appendElement("FILETABLE_DIRECTORY");
		return instance();
	}

	/**
	 * FILETABLE_COLLATE_FILENAME句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder filetableCollateFilename() {
		appendElement("FILETABLE_COLLATE_FILENAME");
		return instance();
	}

	/**
	 * FILETABLE_STREAMID_UNIQUE_CONSTRAINT_NAME句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder filetableStreamidUniqueConstraintName() {
		appendElement("FILETABLE_STREAMID_UNIQUE_CONSTRAINT_NAME");
		return instance();
	}

	/**
	 * FILETABLE_FULLPATH_UNIQUE_CONSTRAINT_NAME句を追加します
	 * 
	 * @return
	 */
	public SqlServerSqlBuilder filetableFullpathUniqueConstraintName() {
		appendElement("FILETABLE_FULLPATH_UNIQUE_CONSTRAINT_NAME");
		return instance();
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.sqlapp.util.AbstractSqlBuilder#appendArgumentBefore(com.sqlapp.data
	 * .schemas.NamedArgument)
	 */
	@Override
	protected void argumentBefore(NamedArgument obj) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.sqlapp.util.AbstractSqlBuilder#appendArgumentAfter(com.sqlapp.data
	 * .schemas.NamedArgument)
	 */
	@Override
	protected void argumentAfter(NamedArgument obj) {
		argumentDirection(obj);
		if (!CommonUtils.isEmpty(obj.getDefaultValue())) {
			this.space().eq().space()._add(obj.getDefaultValue());
		}
		if (obj.getReadonly() != null && obj.getReadonly().booleanValue()) {
			this.space().readonly();
		}
	}

	/**
	 * 引数コレクションを追加します
	 * 
	 * @param arguments
	 * @return
	 */
	@Override
	public SqlServerSqlBuilder arguments(
			NamedArgumentCollection<?> arguments) {
		if (arguments.getParent() instanceof Procedure) {
			return arguments("\n\t", arguments, "", "\n\t, ");
		} else {
			return arguments("(", arguments, ")", ", ");
		}
	}

	@Override
	public SqlServerSqlBuilder clone(){
		return (SqlServerSqlBuilder)super.clone();
	}
}
