/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ColumnPrivilege;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005ColumnPrivilegeReader
extends ColumnPrivilegeReader {
    protected SqlServer2005ColumnPrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ColumnPrivilege> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                ColumnPrivilege obj = SqlServer2005ColumnPrivilegeReader.this.createColumnPrivilege(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columnPrivileges2005.sql");
    }

    protected ColumnPrivilege createColumnPrivilege(ExResultSet rs) throws SQLException {
        String catalogName = this.getString((ResultSet)rs, "catalog_name");
        String schemaName = this.getString((ResultSet)rs, "schema_name");
        String objectName = this.getString((ResultSet)rs, "object_name");
        ColumnPrivilege obj = new ColumnPrivilege();
        obj.setCatalogName(catalogName);
        obj.setSchemaName(schemaName);
        obj.setObjectName(objectName);
        obj.setGrantorName(this.getString((ResultSet)rs, "grantor"));
        obj.setGranteeName(this.getString((ResultSet)rs, "grantee"));
        obj.setColumnName(this.getString((ResultSet)rs, "column_name"));
        obj.setPrivilege(this.getString((ResultSet)rs, "permission_name"));
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        obj.setState(this.getString((ResultSet)rs, "state_desc"));
        obj.setGrantable("GRANT_WITH_GRANT_OPTION".equals(this.getString((ResultSet)rs, "state_desc")));
        return obj;
    }
}

